/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.joboffer.generator;

import java.io.IOException;
import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.LocaleUtils;
import org.xml.sax.SAXException;

import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.repository.Content;
import org.ametys.plugins.joboffer.JobOfferConstants;
import org.ametys.runtime.model.DefinitionContext;
import org.ametys.runtime.model.View;

/**
 * Generator for mail to notify of a new application
 *
 */
public class NewJobApplicationMailGenerator extends ServiceableGenerator
{
    private ContentTypesHelper _cTypeHelper;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _cTypeHelper = (ContentTypesHelper) smanager.lookup(ContentTypesHelper.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException
    {
        @SuppressWarnings("unchecked")
        Map<String, Object> params = (Map<String, Object>) objectModel.get(ObjectModelHelper.PARENT_CONTEXT);
        
        Content content = (Content) params.get("content");
        
        contentHandler.startDocument();
        XMLUtils.startElement(contentHandler, "mail");

        View view = _cTypeHelper.getView("main", new String[] {JobOfferConstants.JOB_APPLICATION_CONTENT_TYPE}, new String[0]);
        content.toSAX(contentHandler, LocaleUtils.toLocale(content.getLanguage()), view, false);
        view.toSAX(contentHandler, DefinitionContext.newInstance()
                                                    .withItemTagName("metadata"));
        
        XMLUtils.endElement(contentHandler, "mail");
        contentHandler.endDocument();
    }
}
