/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.joboffer.observer;

import java.util.Map;
import java.util.Set;

import org.ametys.cms.ObservationConstants;
import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.joboffer.JobOfferConstants;

/**
 * {@link Observer}  when the job offer is being modified
 */
public class ModifyingJobOfferObserver extends AbstractJobOfferObserver
{
    @Override
    protected Set<String> _getSupportedEventIds()
    {
        return Set.of(ObservationConstants.EVENT_CONTENT_MODIFYING);
    }

    @Override
    protected void _internalObserver(Event event, Content content, Map<String, Object> transientVars) throws Exception
    {
        UserIdentity[] personsInCharge = content.getValue(JobOfferConstants.JOB_OFFER_ATTRIBUTE_PATH_PERSON_IN_CHARGE);
        _getRequest().setAttribute(REQUEST_ATTR_PERSON_IN_CHARGE, personsInCharge);
    }
    
}
