/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.joboffer.transformation;

import org.apache.avalon.framework.activity.Initializable;

import org.ametys.cms.transformation.URIResolver;
import org.ametys.core.util.HttpUtils;
import org.ametys.plugins.repository.data.ametysobject.ModelAwareDataAwareAmetysObject;
import org.ametys.runtime.config.Config;

/**
 * {@link URIResolver} for type "joboffer-attribute".<br>
 */
public class AttributeURIResolver extends org.ametys.cms.transformation.AttributeURIResolver implements Initializable
{
    private String _baseURL;
    
    public void initialize() throws Exception
    {
        _baseURL = HttpUtils.sanitize(Config.getInstance().getValue("cms.url"));
    }
    
    @Override
    public String getType()
    {
        return "joboffer-attribute";
    }
    
    @Override
    protected String getUri(String path, ModelAwareDataAwareAmetysObject object, boolean download, boolean absolute, boolean internal)
    {
        // Override getUri method to have BO URI for job offer attribute (because application contents are never published in live)
        return internal
            ? super.getUri(path, object, download, absolute, internal)
            : _baseURL + path;
    }
}
