/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.linkdirectory;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.linkdirectory.DirectoryHelper;
import org.ametys.plugins.linkdirectory.LinkDirectoryThemesInputDataHelper;
import org.ametys.plugins.linkdirectory.repository.DefaultLink;
import org.ametys.web.inputdata.InputData;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.Site;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class LinkDirectoryInputData
extends AbstractLogEnabled
implements Contextualizable,
InputData,
Serviceable {
    protected CurrentUserProvider _currentUserProvider;
    protected LinkDirectoryThemesInputDataHelper _linkDirectoryThemesInputDataHelper;
    private Context _context;
    private DirectoryHelper _directoryHelper;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._linkDirectoryThemesInputDataHelper = (LinkDirectoryThemesInputDataHelper)((Object)manager.lookup(LinkDirectoryThemesInputDataHelper.ROLE));
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._directoryHelper = (DirectoryHelper)((Object)manager.lookup(DirectoryHelper.ROLE));
    }

    public boolean isCacheable(Site site, Page currentPage) {
        Request request = ContextHelper.getRequest((Context)this._context);
        String template = this._getTemplate(request);
        if (template == null) {
            return true;
        }
        try {
            LinkDirectoryThemesInputDataHelper.ConfiguredThemesInputData configuredThemesInputData = this._linkDirectoryThemesInputDataHelper.getThemesInputData(site.getSkinId());
            List<LinkDirectoryThemesInputDataHelper.ThemesInputData> themesInputData = this._getThemesForSkinAndTemplate(configuredThemesInputData, template);
            if (themesInputData.isEmpty()) {
                return true;
            }
            for (LinkDirectoryThemesInputDataHelper.ThemesInputData themeInputData : themesInputData) {
                if (!themeInputData.configurable() && !themeInputData.displayUserLinks()) continue;
                return false;
            }
            String language = this._directoryHelper.getLanguage(request);
            List<String> configuredThemesNames = themesInputData.stream().map(inputData -> this._getConfiguredThemes((LinkDirectoryThemesInputDataHelper.ThemesInputData)inputData, language)).flatMap(Collection::stream).collect(Collectors.toList());
            String siteName = this._directoryHelper.getSiteName(request);
            return !this._directoryHelper.hasRestrictions(siteName, language, configuredThemesNames) && !this._directoryHelper.hasInternalUrl(siteName, language, configuredThemesNames);
        }
        catch (Exception e) {
            this.getLogger().error("An error occurred while retrieving information from the skin configuration", (Throwable)e);
            return true;
        }
    }

    public void toSAX(ContentHandler contentHandler) throws ProcessingException {
        Request request = ContextHelper.getRequest((Context)this._context);
        UserIdentity user = this._currentUserProvider.getUser();
        String template = this._getTemplate(request);
        if (template == null) {
            this.getLogger().info("There is no current template");
            return;
        }
        String skinId = this._getSkin(request);
        if (skinId == null) {
            this.getLogger().info("There is no current skin");
            return;
        }
        try {
            contentHandler.startDocument();
            LinkDirectoryThemesInputDataHelper.ConfiguredThemesInputData configuredThemesInputData = this._linkDirectoryThemesInputDataHelper.getThemesInputData(skinId);
            List<LinkDirectoryThemesInputDataHelper.ThemesInputData> themesInputDatas = this._getThemesForSkinAndTemplate(configuredThemesInputData, template);
            String error = configuredThemesInputData.error();
            if (StringUtils.isNotBlank((CharSequence)error)) {
                AttributesImpl attrs = new AttributesImpl();
                attrs.addCDATAAttribute("error", error);
                XMLUtils.createElement((ContentHandler)contentHandler, (String)"linkDirectory", (Attributes)attrs);
            } else {
                String language = this._directoryHelper.getLanguage(request);
                String siteName = this._directoryHelper.getSiteName(request);
                for (LinkDirectoryThemesInputDataHelper.ThemesInputData themesInputData : themesInputDatas) {
                    AttributesImpl attrs = new AttributesImpl();
                    attrs.addCDATAAttribute("applicable", Boolean.TRUE.toString());
                    attrs.addCDATAAttribute("configurable", String.valueOf(themesInputData.configurable()));
                    attrs.addCDATAAttribute("displayUserLinks", String.valueOf(themesInputData.displayUserLinks()));
                    attrs.addCDATAAttribute("id", themesInputData.id());
                    XMLUtils.startElement((ContentHandler)contentHandler, (String)"linkDirectory", (Attributes)attrs);
                    List<String> configuredThemesNames = this._getConfiguredThemes(themesInputData, language);
                    if (configuredThemesNames != null) {
                        Map<String, List<String>> themesMap = this._directoryHelper.getThemesMap(configuredThemesNames, siteName, language);
                        List<String> correctThemesIds = themesMap.get("themes");
                        List<String> unknownThemesNames = themesMap.get("unknown-themes");
                        this._saxThemes(contentHandler, correctThemesIds, unknownThemesNames);
                        this._saxLinks(contentHandler, user, request, correctThemesIds, themesInputData.displayUserLinks(), themesInputData.configurable(), themesInputData.id());
                    }
                    XMLUtils.endElement((ContentHandler)contentHandler, (String)"linkDirectory");
                }
            }
        }
        catch (Exception e) {
            this.getLogger().error("An exception occurred during the processing of the link directory's input data", (Throwable)e);
        }
    }

    private void _saxThemes(ContentHandler contentHandler, List<String> themeIds, List<String> unknownThemesNames) throws SAXException {
        if (!themeIds.isEmpty()) {
            XMLUtils.startElement((ContentHandler)contentHandler, (String)"themes");
            for (String themeId : themeIds) {
                XMLUtils.createElement((ContentHandler)contentHandler, (String)"theme", (String)themeId);
            }
            XMLUtils.endElement((ContentHandler)contentHandler, (String)"themes");
        }
        if (!unknownThemesNames.isEmpty()) {
            AttributesImpl attr = new AttributesImpl();
            attr.addCDATAAttribute("count", Integer.toString(unknownThemesNames.size()));
            XMLUtils.createElement((ContentHandler)contentHandler, (String)"unknown-themes", (Attributes)attr, (String)StringUtils.join(unknownThemesNames, (String)", "));
        }
    }

    private void _saxLinks(ContentHandler contentHandler, UserIdentity user, Request request, List<String> themeIds, boolean displayUserLinks, boolean configurable, String specificContext) throws ProcessingException {
        String language = this._directoryHelper.getLanguage(request);
        String siteName = this._directoryHelper.getSiteName(request);
        try {
            List<DefaultLink> links = this._directoryHelper.getLinks(themeIds, siteName, language);
            List<DefaultLink> userLinks = null;
            if (user != null && displayUserLinks) {
                userLinks = this._directoryHelper.getUserLinks(siteName, language, user).stream().collect(Collectors.toList());
            }
            XMLUtils.startElement((ContentHandler)contentHandler, (String)"links");
            try {
                String storageContext = siteName + "/" + language;
                if (StringUtils.isNotEmpty((CharSequence)specificContext)) {
                    storageContext = storageContext + "/" + specificContext;
                }
                this._directoryHelper.saxLinks(siteName, contentHandler, links, userLinks, themeIds, configurable, this._directoryHelper.getContextVars(request), storageContext, user);
            }
            catch (Exception e) {
                this.getLogger().error("An exception occurred while saxing the links", (Throwable)e);
            }
            XMLUtils.endElement((ContentHandler)contentHandler, (String)"links");
        }
        catch (Exception e) {
            throw new ProcessingException("An error occurred while retrieving or saxing the links", (Throwable)e);
        }
    }

    private List<String> _getConfiguredThemes(LinkDirectoryThemesInputDataHelper.ThemesInputData themesInputData, String lang) {
        return themesInputData.themes().stream().filter(t -> t.get("lang") == null || ((String)t.get("lang")).equals(lang)).map(t -> (String)t.get("id")).collect(Collectors.toList());
    }

    private List<LinkDirectoryThemesInputDataHelper.ThemesInputData> _getThemesForSkinAndTemplate(LinkDirectoryThemesInputDataHelper.ConfiguredThemesInputData configuredThemesInputData, String template) {
        List<LinkDirectoryThemesInputDataHelper.ThemesInputData> themesInputDatas = configuredThemesInputData.themesInputDatas();
        if (themesInputDatas == null) {
            return List.of();
        }
        return themesInputDatas.stream().filter(t -> this._filterByTemplate((LinkDirectoryThemesInputDataHelper.ThemesInputData)t, template)).collect(Collectors.toList());
    }

    private boolean _filterByTemplate(LinkDirectoryThemesInputDataHelper.ThemesInputData theme, String template) {
        List<String> templates = theme.templates();
        return templates.contains(template) || templates.contains("*");
    }

    private String _getTemplate(Request request) {
        return (String)request.getAttribute("template");
    }

    private String _getSkin(Request request) {
        return (String)request.getAttribute("skin");
    }
}

