/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.linkdirectory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.plugins.linkdirectory.DirectoryHelper;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;

public class LinkDirectoryThemesInputDataHelper
extends AbstractLogEnabled
implements Component,
Serviceable,
Initializable {
    public static final String ROLE = LinkDirectoryThemesInputDataHelper.class.getName();
    public static final String WILDCARD = "*";
    private static final String __CONF_FILE_PATH = "skin://conf/link-directory.xml";
    private static final String __THEMES_CACHE = LinkDirectoryThemesInputDataHelper.class.getName() + "$skinInputDataThemesCache";
    private SourceResolver _sourceResolver;
    private DirectoryHelper _directoryHelper;
    private AbstractCacheManager _cacheManager;
    private Map<String, String> _configurationError;
    private Map<String, Long> _lastConfUpdate;

    public void initialize() throws Exception {
        this._lastConfUpdate = new HashMap<String, Long>();
        this._configurationError = new HashMap<String, String>();
        this._cacheManager.createMemoryCache(__THEMES_CACHE, new I18nizableText("plugin.link-directory", "PLUGINS_LINK_DIRECTORY_CACHE_THEMES_LABEL"), new I18nizableText("plugin.link-directory", "PLUGINS_LINK_DIRECTORY_CACHE_THEMES_DESCRIPTION"), true, null);
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._directoryHelper = (DirectoryHelper)((Object)manager.lookup(DirectoryHelper.ROLE));
        this._cacheManager = (AbstractCacheManager)manager.lookup(AbstractCacheManager.ROLE);
    }

    public ConfiguredThemesInputData getThemesInputData(String skinId) {
        try {
            this._updateConfigurationValues(skinId);
            if (this._configurationError.containsKey(skinId)) {
                return new ConfiguredThemesInputData(List.of(), this._configurationError.get(skinId));
            }
            return new ConfiguredThemesInputData((List)this._getThemesCache().get((Object)skinId, k -> new ArrayList()), null);
        }
        catch (Exception e) {
            this.getLogger().error("An error occurred while retrieving information from the skin configuration", (Throwable)e);
            return new ConfiguredThemesInputData(List.of(), null);
        }
    }

    private void _updateConfigurationValues(String skinId) throws Exception {
        Source source = null;
        try {
            source = this._sourceResolver.resolveURI(__CONF_FILE_PATH);
            if (source.exists()) {
                this._cacheConfigurationValues(source, skinId, !this._getThemesCache().hasKey((Object)skinId));
            } else {
                if (this.getLogger().isInfoEnabled()) {
                    this.getLogger().info("There is no configuration file at path 'skin://conf/link-directory.xml' (no input data for link directory).");
                }
                this._lastConfUpdate.put(skinId, 0L);
                this._getThemesCache().put((Object)skinId, null);
            }
        }
        finally {
            if (this._sourceResolver != null && source != null) {
                this._sourceResolver.release(source);
            }
        }
    }

    private synchronized void _cacheConfigurationValues(Source source, String skinId, boolean forceRead) {
        long lastModified = source.getLastModified();
        if (!forceRead && this._lastConfUpdate.containsKey(skinId) && this._lastConfUpdate.get(skinId) != 0L && lastModified == this._lastConfUpdate.get(skinId)) {
            return;
        }
        ArrayList<ThemesInputData> themesCache = new ArrayList<ThemesInputData>();
        this.getLogger().info("Caching configuration");
        try {
            Configuration[] themesConfigurations;
            Configuration configuration = this._directoryHelper.getSkinLinksConfiguration(skinId);
            for (Configuration themesConfiguration : themesConfigurations = configuration.getChild("inputdata").getChildren("themes")) {
                Configuration[] themeConfigurations;
                ArrayList<Map<String, String>> themes = new ArrayList<Map<String, String>>();
                for (Configuration themeConfiguration : themeConfigurations = themesConfiguration.getChildren()) {
                    HashMap<String, String> theme = new HashMap<String, String>();
                    String id = themeConfiguration.getAttribute("id", null);
                    theme.put("id", id);
                    theme.put("lang", themeConfiguration.getAttribute("lang", null));
                    themes.add(theme);
                }
                String[] templates = StringUtils.split((String)themesConfiguration.getAttribute("templates", WILDCARD), (char)',');
                ThemesInputData themeInputData = new ThemesInputData(themesConfiguration.getAttribute("inputDataId", ""), Arrays.asList(templates), themes, themesConfiguration.getAttributeAsBoolean("configurable", false), themesConfiguration.getAttributeAsBoolean("displayUserLinks", false));
                themesCache.add(themeInputData);
            }
            this._configurationError.remove(skinId);
            this._getThemesCache().put((Object)skinId, themesCache);
            this._lastConfUpdate.put(skinId, source.getLastModified());
        }
        catch (Exception e) {
            this.getLogger().warn("An error occured while getting the configuration's file values", (Throwable)e);
            this._configurationError.put(skinId, e.getMessage());
        }
    }

    private Cache<String, List<ThemesInputData>> _getThemesCache() {
        return this._cacheManager.get(__THEMES_CACHE);
    }

    public record ConfiguredThemesInputData(List<ThemesInputData> themesInputDatas, String error) {
    }

    public record ThemesInputData(String id, List<String> templates, List<Map<String, String>> themes, boolean configurable, boolean displayUserLinks) {
    }
}

