/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.linkdirectory;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.dom.AmetysNodeList;
import org.ametys.core.util.dom.MapElement;
import org.ametys.plugins.linkdirectory.DirectoryHelper;
import org.ametys.plugins.linkdirectory.LinkDirectoryColorsComponent;
import org.ametys.plugins.linkdirectory.repository.DefaultLink;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.ametys.web.transformation.xslt.AmetysXSLTHelper;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.xml.XMLUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;

public class LinkDirectoryXSLTHelper
extends AmetysXSLTHelper {
    private static LinkDirectoryColorsComponent _linkDirectoryColorsComponent;
    private static DirectoryHelper _directoryHelper;
    private static SiteManager _siteManager;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        _linkDirectoryColorsComponent = (LinkDirectoryColorsComponent)((Object)manager.lookup(LinkDirectoryColorsComponent.ROLE));
        _directoryHelper = (DirectoryHelper)((Object)manager.lookup(DirectoryHelper.ROLE));
        _siteManager = (SiteManager)manager.lookup(SiteManager.ROLE);
    }

    public static MapElement getColors() {
        String siteName = LinkDirectoryXSLTHelper.site();
        return LinkDirectoryXSLTHelper.getColors(siteName);
    }

    public static MapElement getColors(String siteName) {
        Map colors = _linkDirectoryColorsComponent.getColors(siteName);
        return new MapElement("colors", colors);
    }

    public static String getDefaultColorIndex() {
        String siteName = LinkDirectoryXSLTHelper.site();
        return LinkDirectoryXSLTHelper.getDefaultColorIndex(siteName);
    }

    public static String getDefaultColorIndex(String siteName) {
        return _linkDirectoryColorsComponent.getDefaultKey(siteName);
    }

    public static NodeList getLinks(String siteName, String lang, String themeName) {
        return LinkDirectoryXSLTHelper._getLinks(siteName, lang, themeName, null, false);
    }

    public static NodeList getLinksForCurrentUser(String siteName, String lang, String themeName) {
        return LinkDirectoryXSLTHelper._getLinks(siteName, lang, themeName, _currentUserProvider.getUser(), true);
    }

    public static boolean isInternalIP() {
        String siteName = LinkDirectoryXSLTHelper.site();
        Site site = _siteManager.getSite(siteName);
        return site != null ? _directoryHelper.isInternalIP(site) : false;
    }

    private static NodeList _getLinks(String siteName, String lang, String themeName, UserIdentity user, boolean checkIPAuthorization) {
        try {
            Site site = _siteManager.getSite(siteName);
            boolean hasIPRestriction = _directoryHelper.hasIPRestriction(site);
            boolean isIPAuthorized = checkIPAuthorization ? _directoryHelper.isInternalIP(site) : false;
            List<DefaultLink> links = _directoryHelper.getLinks(List.of(themeName), siteName, lang);
            SAXTransformerFactory saxTransformerFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
            TransformerHandler th = saxTransformerFactory.newTransformerHandler();
            DOMResult result = new DOMResult();
            th.setResult(result);
            th.startDocument();
            XMLUtils.startElement((ContentHandler)th, (String)"links");
            for (DefaultLink link : links) {
                if (!_rightManager.hasReadAccess(user, (Object)link)) continue;
                _directoryHelper.saxLink(siteName, th, link, List.of(), false, hasIPRestriction, isIPAuthorized, false, false);
            }
            XMLUtils.endElement((ContentHandler)th, (String)"links");
            th.endDocument();
            ArrayList<Node> linkNodes = new ArrayList<Node>();
            NodeList childNodes = result.getNode().getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node n = childNodes.item(i);
                linkNodes.add(n);
            }
            return new AmetysNodeList(linkNodes);
        }
        catch (Exception e) {
            _logger.error("Unable to sax links directory for theme '" + themeName + " 'and site name '" + siteName + "'", (Throwable)e);
            return null;
        }
    }
}

