/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.linkdirectory.dynamic;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.linkdirectory.dynamic.DynamicInformationHandler;
import org.ametys.plugins.linkdirectory.dynamic.DynamicInformationProvider;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.plugin.component.PluginAware;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.SourceResolver;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class URLBasedDynamicInformationProvider
extends AbstractLogEnabled
implements DynamicInformationProvider,
Configurable,
PluginAware,
Serviceable {
    private static final Pattern __CONFIG_PARAM_PATTERN = Pattern.compile("\\$\\{config:([^}]+)\\}");
    private static final Pattern __SITE_CONFIG_PARAM_PATTERN = Pattern.compile("\\$\\{site-config:([^}]+)\\}");
    private String _url;
    private SiteManager _siteManager;
    private String _pluginName;
    private I18nizableText _label;
    private String _id;
    private SourceResolver _sourceResolver;

    public void service(ServiceManager manager) throws ServiceException {
        this._sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._siteManager = (SiteManager)manager.lookup(SiteManager.ROLE);
    }

    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
        this._id = id;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this._url = configuration.getChild("url").getValue();
        this._label = I18nizableText.parseI18nizableText((Configuration)configuration.getChild("label"), (String)("plugin." + this._pluginName), (String)"");
    }

    @Override
    public void saxDynamicInformation(ContentHandler contentHandler, String linkId, String siteName, String lang, int nbItems) throws Exception {
        String url = this._handleVariable(this._url, siteName, lang, nbItems);
        try (InputStream is = this._sourceResolver.resolveURI(url).getInputStream();){
            byte[] asByteArray = IOUtils.toByteArray((InputStream)is);
            if (this._xsdValidation(new ByteArrayInputStream(asByteArray))) {
                AttributesImpl attrs = new AttributesImpl();
                attrs.addCDATAAttribute("id", linkId);
                XMLUtils.startElement((ContentHandler)contentHandler, (String)"dynamic-information", (Attributes)attrs);
                this._saxInformation(contentHandler, new ByteArrayInputStream(asByteArray));
                XMLUtils.endElement((ContentHandler)contentHandler, (String)"dynamic-information");
            }
        }
    }

    private String _handleVariable(String url, String siteName, String lang, int nbItems) {
        int startParamIndex = url.indexOf("?");
        String convertUrl = url;
        convertUrl = StringUtils.replace((String)convertUrl, (String)"${lang}", (String)lang);
        convertUrl = StringUtils.replace((String)convertUrl, (String)"${site}", (String)siteName);
        convertUrl = StringUtils.replace((String)convertUrl, (String)"${maxItems}", (String)String.valueOf(nbItems));
        Matcher confMatcher = __CONFIG_PARAM_PATTERN.matcher(convertUrl);
        while (confMatcher.find()) {
            String paramName = confMatcher.group(1);
            String paramValue = (String)Config.getInstance().getValue(paramName);
            String encodedValue = confMatcher.start() > startParamIndex ? URIUtils.encodeParameter((String)paramValue) : URIUtils.encodePath((String)paramValue);
            convertUrl = StringUtils.replace((String)convertUrl, (String)confMatcher.group(0), (String)encodedValue);
        }
        Matcher siteConfMatcher = __SITE_CONFIG_PARAM_PATTERN.matcher(convertUrl);
        Site site = this._siteManager.getSite(siteName);
        while (siteConfMatcher.find()) {
            String paramName = confMatcher.group(1);
            String paramValue = (String)site.getValue(paramName);
            String encodedValue = siteConfMatcher.start() > startParamIndex ? URIUtils.encodeParameter((String)paramValue) : URIUtils.encodePath((String)paramValue);
            convertUrl = StringUtils.replace((String)convertUrl, (String)siteConfMatcher.group(0), (String)encodedValue);
        }
        return convertUrl;
    }

    private boolean _xsdValidation(InputStream xml) {
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            URL schemaURL = this.getClass().getResource("dynamic-information.xsd");
            Schema schema = factory.newSchema(schemaURL);
            Validator validator = schema.newValidator();
            validator.validate(new StreamSource(xml));
            return true;
        }
        catch (Exception e) {
            this.getLogger().error("Unable to validate XSD for '{}' ({}) information at '{}' url.", new Object[]{this._label, this._id, this._url, e});
            return false;
        }
    }

    private void _saxInformation(ContentHandler contentHandler, InputStream xml) throws Exception {
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        saxFactory.setNamespaceAware(true);
        XMLReader reader = saxFactory.newSAXParser().getXMLReader();
        DynamicInformationHandler dynamicInfoHandler = new DynamicInformationHandler(contentHandler);
        reader.setContentHandler((ContentHandler)((Object)dynamicInfoHandler));
        reader.parse(new InputSource(xml));
    }

    public String getUrl() {
        return this._url;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public I18nizableText getLabel() {
        return this._label;
    }
}

