/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.linkdirectory.link;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.upload.Upload;
import org.ametys.core.upload.UploadManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.linkdirectory.DirectoryHelper;
import org.ametys.plugins.linkdirectory.Link;
import org.ametys.plugins.linkdirectory.link.LinkDAO;
import org.ametys.web.repository.site.SiteManager;
import org.ametys.web.url.UrlPreviewComponent;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class AddUserLinkAction
extends ServiceableAction {
    private static int _ICO_REQUEST_TIMEOUT = 3000;
    private static final List<String> __ICO_SUPPORTED_MIMETYPES = List.of("image/jpeg", "image/jpg", "image/png", "image/svg+xml");
    private static final List<String> __ICO_SUPPORTED_EXTENSIONS = List.of(".jpeg", ".jpg", ".png", ".svg");
    protected LinkDAO _linkDAO;
    protected CurrentUserProvider _currentUserProvider;
    protected DirectoryHelper _directoryHelper;
    protected SiteManager _siteManager;
    protected UrlPreviewComponent _urlPreviewComponent;
    protected UploadManager _uploadManager;
    protected JSONUtils _jsonUtils;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
        this._linkDAO = (LinkDAO)((Object)smanager.lookup(LinkDAO.ROLE));
        this._directoryHelper = (DirectoryHelper)((Object)smanager.lookup(DirectoryHelper.ROLE));
        this._siteManager = (SiteManager)smanager.lookup(SiteManager.ROLE);
        this._urlPreviewComponent = (UrlPreviewComponent)smanager.lookup(UrlPreviewComponent.ROLE);
        this._uploadManager = (UploadManager)smanager.lookup(UploadManager.ROLE);
        this._jsonUtils = (JSONUtils)smanager.lookup(JSONUtils.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        HashMap<String, Object> result = new HashMap<String, Object>();
        UserIdentity user = this._currentUserProvider.getUser();
        if (user != null) {
            HashMap<String, Object> createParameters = new HashMap<String, Object>();
            String siteName = request.getParameter("siteName");
            String lang = request.getParameter("lang");
            String url = request.getParameter("url");
            String color = request.getParameter("color");
            createParameters.put("siteName", siteName);
            createParameters.put("lang", lang);
            createParameters.put("url-type", Link.LinkType.URL.toString());
            createParameters.put("url", url);
            createParameters.put("title", request.getParameter("title"));
            createParameters.put("color", color);
            String userAgent = request.getHeader("User-Agent");
            Upload upload = this._getLinkFavicon(url, user, userAgent);
            if (upload != null) {
                HashMap<String, String> linkMap = new HashMap<String, String>();
                linkMap.put("id", upload.getId());
                linkMap.put("type", "external");
                createParameters.put("picture", this._jsonUtils.convertObjectToJson(linkMap));
            }
            this._handleTheme(request, createParameters, siteName, lang);
            Map<String, Object> createdLinkresult = this._linkDAO.createUserLink(createParameters);
            if (createdLinkresult.containsKey("already-exists")) {
                result.put("error", "already-exists");
            } else {
                result.put("error", "none");
                result.putAll(createdLinkresult);
            }
        } else {
            result.put("error", "unauthenticated-user");
        }
        Response response = ObjectModelHelper.getResponse((Map)objectModel);
        response.setHeader("Access-Control-Allow-Origin", request.getHeader("Origin"));
        response.setHeader("Access-Control-Allow-Credentials", "true");
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }

    private void _handleTheme(Request request, Map<String, Object> createParameters, String siteName, String lang) {
        String themeName = request.getParameter("themes");
        ArrayList<String> themes = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)themeName) && this._directoryHelper.themeExists(themeName, siteName, lang)) {
            themes.add(themeName);
        }
        createParameters.put("themes", themes);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Upload _getLinkFavicon(String url, UserIdentity user, String userAgent) {
        Upload upload = null;
        try {
            String favIconLink = this._urlPreviewComponent.getFavicon(url);
            if (StringUtils.isBlank((CharSequence)favIconLink)) {
                return null;
            }
            URL favIconURL = new URL(favIconLink);
            String favIconName = StringUtils.substringAfterLast((String)favIconURL.getPath(), (String)"/");
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(_ICO_REQUEST_TIMEOUT).setConnectionRequestTimeout(_ICO_REQUEST_TIMEOUT).setSocketTimeout(_ICO_REQUEST_TIMEOUT).build();
            try (CloseableHttpClient httpclient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).useSystemProperties().setUserAgent(userAgent).build();){
                HttpGet get = new HttpGet(favIconLink);
                try (CloseableHttpResponse httpResponse = httpclient.execute((HttpUriRequest)get);){
                    int statusCode = httpResponse.getStatusLine().getStatusCode();
                    if (statusCode != 200) {
                        this.getLogger().warn("Error " + statusCode + ". Can't set the favicon with url " + favIconLink + " to the link " + url);
                        Upload upload2 = upload;
                        return upload2;
                    }
                    try (InputStream is = httpResponse.getEntity().getContent();){
                        HttpEntity entity = httpResponse.getEntity();
                        String mimeType = ContentType.get((HttpEntity)entity).getMimeType();
                        if (mimeType.equals("image/x-icon") || mimeType.equals("image/vnd.microsoft.icon") || favIconName.endsWith(".ico")) {
                            InputStream convertedIcoToPngIS = this._urlPreviewComponent.convertIcoToPng(is);
                            upload = this._uploadManager.storeUpload(user, StringUtils.replace((String)favIconName, (String)".ico", (String)".png"), convertedIcoToPngIS);
                            return upload;
                        }
                        if (this._checkFavico(favIconName, mimeType)) {
                            upload = this._uploadManager.storeUpload(user, favIconName, is);
                            return upload;
                        }
                        this.getLogger().warn("Unsupported mime-type " + mimeType + " for favicon from url " + favIconLink + " to the link " + url);
                        return upload;
                    }
                }
            }
            catch (IOException e) {
                this.getLogger().warn("Unable to download favicon from url " + favIconLink + " to the link " + url, (Throwable)e);
                return upload;
            }
        }
        catch (Exception e) {
            this.getLogger().warn("Unable to get favicon from link url " + url, (Throwable)e);
        }
        return upload;
    }

    private boolean _checkFavico(String favicoName, String mimeType) {
        return __ICO_SUPPORTED_MIMETYPES.stream().anyMatch(m -> StringUtils.equalsIgnoreCase((CharSequence)m, (CharSequence)mimeType)) || __ICO_SUPPORTED_EXTENSIONS.stream().anyMatch(ext -> favicoName.toLowerCase().endsWith((String)ext));
    }
}

