/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.linkdirectory.link;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import org.ametys.cms.data.Binary;
import org.ametys.cms.transformation.xslt.ResolveURIComponent;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.right.ProfileAssignmentStorageExtensionPoint;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.upload.Upload;
import org.ametys.core.upload.UploadManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.linkdirectory.DirectoryHelper;
import org.ametys.plugins.linkdirectory.Link;
import org.ametys.plugins.linkdirectory.LinkDirectoryColorsComponent;
import org.ametys.plugins.linkdirectory.dynamic.DynamicInformationProvider;
import org.ametys.plugins.linkdirectory.dynamic.DynamicInformationProviderExtensionPoint;
import org.ametys.plugins.linkdirectory.repository.DefaultLink;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectIterator;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.ModifiableAmetysObject;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.TraversableAmetysObject;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.jcr.NameHelper;
import org.ametys.plugins.repository.provider.RequestAttributeWorkspaceSelector;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;

public class LinkDAO
extends AbstractLogEnabled
implements Serviceable,
Component,
Contextualizable {
    public static final String ROLE = LinkDAO.class.getName();
    private AmetysObjectResolver _resolver;
    private ObservationManager _observationManager;
    private SiteManager _siteManager;
    private CurrentUserProvider _currentUserProvider;
    private UploadManager _uploadManager;
    private RightManager _rightManager;
    private ProfileAssignmentStorageExtensionPoint _profileAssignmentStorageEP;
    private JSONUtils _jsonUtils;
    private DirectoryHelper _directoryHelper;
    private Context _cocoonContext;
    private org.apache.avalon.framework.context.Context _context;
    private DynamicInformationProviderExtensionPoint _dynamicInfoExtensionPoint;
    private LinkDirectoryColorsComponent _colorComponent;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._observationManager = (ObservationManager)manager.lookup(ObservationManager.ROLE);
        this._siteManager = (SiteManager)manager.lookup(SiteManager.ROLE);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._uploadManager = (UploadManager)manager.lookup(UploadManager.ROLE);
        this._jsonUtils = (JSONUtils)manager.lookup(JSONUtils.ROLE);
        this._directoryHelper = (DirectoryHelper)((Object)manager.lookup(DirectoryHelper.ROLE));
        this._dynamicInfoExtensionPoint = (DynamicInformationProviderExtensionPoint)((Object)manager.lookup(DynamicInformationProviderExtensionPoint.ROLE));
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        this._profileAssignmentStorageEP = (ProfileAssignmentStorageExtensionPoint)manager.lookup(ProfileAssignmentStorageExtensionPoint.ROLE);
        this._colorComponent = (LinkDirectoryColorsComponent)((Object)manager.lookup(LinkDirectoryColorsComponent.ROLE));
    }

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this._context = context;
        this._cocoonContext = (Context)context.get((Object)"environment-context");
    }

    @Callable(rights={"LinkDirectory_Rights_Links_Handle"})
    public Map<String, Object> createLink(Map<String, Object> parameters) {
        String internalUrl;
        HashMap<String, Object> result = new HashMap<String, Object>();
        String siteName = (String)parameters.get("siteName");
        String language = (String)parameters.get("lang");
        Site site = this._siteManager.getSite(siteName);
        String url = StringUtils.defaultString((String)((String)parameters.get("url")));
        if (this._urlExists(url, internalUrl = StringUtils.defaultString((String)((String)parameters.get("internal-url"))), siteName, language)) {
            result.put("already-exists", true);
            return result;
        }
        ModifiableTraversableAmetysObject rootNode = this._directoryHelper.getLinksNode(site, language);
        String name = url;
        if (StringUtils.isBlank((CharSequence)name)) {
            name = internalUrl;
        }
        DefaultLink link = this._createLink(name, rootNode);
        this._setValues(link, parameters);
        rootNode.saveChanges();
        HashMap<String, String> eventParams = new HashMap<String, String>();
        eventParams.put("object.id", link.getId());
        eventParams.put("object.parent", rootNode.getId());
        eventParams.put("object.name", link.getName());
        eventParams.put("object.path", link.getPath());
        this._observationManager.notify(new Event("link.created", this._currentUserProvider.getUser(), eventParams));
        this._setAccess(link, null);
        return this.convertLink2JsonObject(link);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> createUserLink(Map<String, Object> parameters) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Request request = ContextHelper.getRequest((org.apache.avalon.framework.context.Context)this._context);
        String currentWsp = RequestAttributeWorkspaceSelector.getForcedWorkspace((Request)request);
        DefaultLink link = null;
        try {
            String internalUrl;
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)"default");
            UserIdentity currentUser = this._currentUserProvider.getUser();
            if (currentUser == null) {
                result.put("unauthenticated-user", true);
                HashMap<String, Object> hashMap = result;
                return hashMap;
            }
            String siteName = (String)parameters.get("siteName");
            String language = (String)parameters.get("lang");
            Site site = this._siteManager.getSite(siteName);
            String url = StringUtils.defaultString((String)((String)parameters.get("url")));
            if (this._urlExistsForUser(url, internalUrl = StringUtils.defaultString((String)((String)parameters.get("internal-url"))), siteName, language, currentUser)) {
                result.put("already-exists", true);
                HashMap<String, Object> hashMap = result;
                return hashMap;
            }
            ModifiableTraversableAmetysObject rootNodeForUser = this._directoryHelper.getLinksForUserNode(site, language, currentUser);
            String name = url;
            if (StringUtils.isBlank((CharSequence)name)) {
                name = internalUrl;
            }
            link = this._createLink(name, rootNodeForUser);
            this._setValues(link, parameters);
            rootNodeForUser.saveChanges();
            HashMap<String, String> eventParams = new HashMap<String, String>();
            eventParams.put("object.id", link.getId());
            eventParams.put("object.parent", rootNodeForUser.getId());
            eventParams.put("object.name", link.getName());
            eventParams.put("object.path", link.getPath());
            this._observationManager.notify(new Event("link.created", this._currentUserProvider.getUser(), eventParams));
            this._setAccess(link, currentUser);
        }
        finally {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)currentWsp);
        }
        return this.convertLink2JsonObject(link);
    }

    public boolean isUserLink(DefaultLink link) {
        ModifiableTraversableAmetysObject linksNode;
        AmetysObject parent = link.getParent();
        return !parent.equals((Object)(linksNode = this._directoryHelper.getLinksNode(link.getSite(), link.getLanguage())));
    }

    @Callable(rights={"LinkDirectory_Rights_Links_Handle"})
    public Map<String, Object> updateLink(Map<String, Object> parameters) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String siteName = (String)parameters.get("siteName");
        String language = (String)parameters.get("language");
        String id = StringUtils.defaultString((String)((String)parameters.get("id")));
        String url = StringUtils.defaultString((String)((String)parameters.get("url")));
        String internalUrl = StringUtils.defaultString((String)((String)parameters.get("internal-url")));
        try {
            DefaultLink link = (DefaultLink)this._resolver.resolveById(id);
            if (!link.getUrl().equals(url) && this._urlExists(url, internalUrl, siteName, language)) {
                result.put("already-exists", true);
                return result;
            }
            this._setValues(link, parameters);
            link.saveChanges();
            HashMap<String, String> eventParams = new HashMap<String, String>();
            eventParams.put("object.id", link.getId());
            eventParams.put("object.name", link.getName());
            eventParams.put("object.path", link.getPath());
            this._observationManager.notify(new Event("link.modified", this._currentUserProvider.getUser(), eventParams));
            return this.convertLink2JsonObject(link);
        }
        catch (UnknownAmetysObjectException e) {
            result.put("unknown-link", true);
            return result;
        }
        catch (AmetysRepositoryException e) {
            throw new IllegalStateException(e);
        }
    }

    private void _setValues(Link link, Map<String, Object> values) {
        this._setLinkValues(link, values);
        List themes = Collections.EMPTY_LIST;
        Object themesFromValues = values.get("themes");
        if (themesFromValues instanceof List) {
            themes = (List)themesFromValues;
        } else if (themesFromValues instanceof String) {
            themes = this._jsonUtils.convertJsonToList((String)themesFromValues).stream().map(Object::toString).collect(Collectors.toList());
        }
        this._setThemes(link, themes);
    }

    private void _setLinkValues(Link link, Map<String, Object> values) {
        String url = StringUtils.defaultString((String)((String)values.get("url")));
        String dynInfoProviderId = StringUtils.defaultString((String)((String)values.get("dynamic-info-provider")));
        String internalUrl = StringUtils.defaultString((String)((String)values.get("internal-url")));
        String urlType = StringUtils.defaultString((String)((String)values.get("url-type")));
        String title = StringUtils.defaultString((String)((String)values.get("title")));
        String content = StringUtils.defaultString((String)((String)values.get("content")));
        String alternative = StringUtils.defaultString((String)((String)values.get("url-alternative")));
        String color = StringUtils.defaultString((String)((String)values.get("color")));
        String pageId = StringUtils.defaultString((String)((String)values.get("page")));
        String status = StringUtils.defaultString((String)((String)values.get("status")));
        String defaultVisibility = StringUtils.defaultString((String)((String)values.get("default-visibility")));
        String pictureAsStr = StringUtils.defaultString((String)((String)values.get("picture")));
        String pictureAlternative = StringUtils.defaultString((String)((String)values.get("picture-alternative")));
        if (!this._dynamicInfoExtensionPoint.hasExtension(dynInfoProviderId)) {
            dynInfoProviderId = "";
        }
        link.setUrl(Link.LinkType.valueOf(urlType), url);
        link.setDynamicInformationProvider(dynInfoProviderId);
        link.setInternalUrl(internalUrl);
        link.setTitle(title);
        link.setContent(content);
        link.setAlternative(alternative);
        link.setPictureAlternative(pictureAlternative);
        link.setColor(color);
        link.setPage(pageId);
        link.setStatus(StringUtils.isNotBlank((CharSequence)status) ? Link.LinkStatus.valueOf(status) : Link.LinkStatus.NORMAL);
        link.setDefaultVisibility(StringUtils.isNotBlank((CharSequence)defaultVisibility) ? Link.LinkVisibility.valueOf(defaultVisibility) : Link.LinkVisibility.VISIBLE);
        this._setPicture(link, pictureAsStr);
    }

    private void _setThemes(Link link, List<String> themes) {
        link.setThemes(themes.toArray(new String[themes.size()]));
    }

    private void _setPicture(Link link, String valueAsStr) {
        if (StringUtils.isNotEmpty((CharSequence)valueAsStr)) {
            Map picture = this._jsonUtils.convertJsonToMap(valueAsStr);
            if (!picture.isEmpty()) {
                String pictureType = (String)picture.get("type");
                String value = (String)picture.get("id");
                if (pictureType.equals("explorer") && !"untouched".equals(value)) {
                    link.setResourcePicture(value);
                } else if (pictureType.equals("glyph")) {
                    link.setPictureGlyph(value);
                } else if (!"untouched".equals(value)) {
                    UserIdentity user = this._currentUserProvider.getUser();
                    Upload upload = this._uploadManager.getUpload(user, value);
                    String filename = upload.getFilename();
                    String mimeType = upload.getMimeType() != null ? upload.getMimeType() : this._cocoonContext.getMimeType(filename);
                    String finalMimeType = mimeType != null ? mimeType : "application/unknown";
                    link.setExternalPicture(finalMimeType, filename, upload.getInputStream());
                }
            } else {
                link.setNoPicture();
            }
        } else {
            link.setNoPicture();
        }
    }

    @Callable(rights={"LinkDirectory_Rights_Links_Handle"})
    public List<String> deleteLinks(List<String> ids) {
        ArrayList<String> result = new ArrayList<String>();
        for (String id : ids) {
            try {
                DefaultLink link = (DefaultLink)this._resolver.resolveById(id);
                this.deleteLink(link);
                result.add(id);
            }
            catch (UnknownAmetysObjectException e) {
                this.getLogger().error("Unable to delete the link of id '" + id + ", because it does not exist.", (Throwable)e);
            }
        }
        return result;
    }

    public void deleteLink(DefaultLink link) throws AmetysRepositoryException {
        String siteName = link.getSiteName();
        String language = link.getLanguage();
        String linkId = link.getId();
        String name = link.getName();
        String path = link.getPath();
        ModifiableAmetysObject parent = (ModifiableAmetysObject)link.getParent();
        link.remove();
        parent.saveChanges();
        HashMap<String, String> eventParams = new HashMap<String, String>();
        eventParams.put("object.id", linkId);
        eventParams.put("object.name", name);
        eventParams.put("object.path", path);
        eventParams.put("siteName", siteName);
        eventParams.put("language", language);
        this._observationManager.notify(new Event("link.deleted", this._currentUserProvider.getUser(), eventParams));
    }

    @Callable(rights={"LinkDirectory_Rights_Links_Handle"})
    public Map<String, Object> moveLink(String id, String role) throws RepositoryException {
        DefaultLink link = (DefaultLink)this._resolver.resolveById(id);
        switch (role) {
            case "move-first": {
                this._moveFirst(link);
                break;
            }
            case "move-up": {
                this._moveUp(link);
                break;
            }
            case "move-down": {
                this._moveDown(link);
                break;
            }
            case "move-last": {
                this._moveLast(link);
                break;
            }
        }
        return this.convertLink2JsonObject(link);
    }

    @Callable(rights={"LinkDirectory_Rights_Links_Handle"})
    public Map<String, Object> getLink(String id) {
        DefaultLink link = (DefaultLink)this._resolver.resolveById(id);
        return this.convertLink2JsonObject(link);
    }

    @Callable(rights={"LinkDirectory_Rights_Links_Handle"})
    public boolean isInternalURLAllowed(String siteName) {
        Site site = this._siteManager.getSite(siteName);
        String allowedIpParameter = (String)site.getValue("allowed-ip");
        return StringUtils.isNotBlank((CharSequence)allowedIpParameter);
    }

    @Callable(rights={"LinkDirectory_Rights_Links_Handle"})
    public List<Map<String, Object>> getDynamicInformationProviders() {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (String id : this._dynamicInfoExtensionPoint.getExtensionsIds()) {
            DynamicInformationProvider provider = (DynamicInformationProvider)this._dynamicInfoExtensionPoint.getExtension(id);
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("id", provider.getId());
            info.put("label", (String)provider.getLabel());
            result.add(info);
        }
        return result;
    }

    public Map<String, Object> convertLink2JsonObject(DefaultLink link) {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        infos.put("id", link.getId());
        infos.put("lang", link.getLanguage());
        infos.put("url", link.getUrl());
        infos.put("dynamicInfoProvider", link.getDynamicInformationProvider());
        infos.put("internalUrl", link.getInternalUrl());
        infos.put("urlType", link.getUrlType().toString());
        if (link.getUrlType() == Link.LinkType.PAGE) {
            String pageId = link.getUrl();
            try {
                Page page = (Page)this._resolver.resolveById(pageId);
                infos.put("pageTitle", page.getTitle());
            }
            catch (UnknownAmetysObjectException e) {
                infos.put("unknownPage", true);
            }
        }
        infos.put("title", link.getTitle());
        infos.put("alternative", link.getAlternative());
        infos.put("content", StringUtils.defaultString((String)link.getContent()));
        infos.put("pictureAlternative", StringUtils.defaultString((String)link.getPictureAlternative()));
        HashMap<String, Object> pictureInfos = new HashMap<String, Object>();
        String pictureType = link.getPictureType();
        TraversableAmetysObject parent = (TraversableAmetysObject)link.getParent();
        infos.put("position", parent.getChildPosition((AmetysObject)link));
        infos.put("count", parent.getChildren().getSize());
        infos.put("color", StringUtils.defaultString((String)link.getColor()));
        infos.put("page", StringUtils.defaultString((String)link.getPage()));
        if (link.getStatus() != null) {
            infos.put("status", link.getStatus().name());
        }
        infos.put("defaultVisibility", link.getDefaultVisibility().name());
        if (pictureType.equals("resource")) {
            String resourceId = link.getResourcePictureId();
            pictureInfos.put("id", resourceId);
            try {
                Resource resource = (Resource)this._resolver.resolveById(resourceId);
                pictureInfos.put("filename", resource.getName());
                pictureInfos.put("size", resource.getLength());
                pictureInfos.put("type", "explorer");
                pictureInfos.put("lastModified", resource.getLastModified());
                String viewUrl = ResolveURIComponent.resolve((String)"explorer", (String)resourceId, (boolean)false);
                String downloadUrl = ResolveURIComponent.resolve((String)"explorer", (String)resourceId, (boolean)true);
                pictureInfos.put("viewUrl", viewUrl);
                pictureInfos.put("downloadUrl", downloadUrl);
            }
            catch (UnknownAmetysObjectException e) {
                this.getLogger().error("The resource of id'" + resourceId + "' does not exist anymore. The picture for link of id '" + link.getId() + "' will be ignored.", (Throwable)e);
                infos.put("pictureNotFound", true);
            }
        } else if (pictureType.equals("external")) {
            Binary picMeta = link.getExternalPicture();
            pictureInfos.put("path", "picture");
            pictureInfos.put("filename", picMeta.getFilename());
            pictureInfos.put("size", picMeta.getLength());
            pictureInfos.put("lastModified", picMeta.getLastModificationDate());
            pictureInfos.put("type", "link-data");
            String viewUrl = ResolveURIComponent.resolve((String)"link-data", (String)("picture?objectId=" + link.getId()), (boolean)false);
            String downloadUrl = ResolveURIComponent.resolve((String)"link-data", (String)("picture?objectId=" + link.getId()), (boolean)true);
            pictureInfos.put("viewUrl", viewUrl);
            pictureInfos.put("downloadUrl", downloadUrl);
        } else if (pictureType.equals("glyph")) {
            pictureInfos.put("id", link.getPictureGlyph());
            pictureInfos.put("type", "glyph");
        }
        infos.put("picture", pictureInfos);
        infos.put("isRestricted", !this._rightManager.hasAnonymousReadAccess((Object)link));
        ArrayList themesList = new ArrayList();
        for (String themeId : link.getThemes()) {
            try {
                I18nizableText themeTitle = this._directoryHelper.getThemeTitle(themeId, link.getSiteName(), link.getLanguage());
                HashMap<String, String> themeData = new HashMap<String, String>();
                themeData.put("id", themeId);
                themeData.put("label", (String)themeTitle);
                themesList.add(themeData);
            }
            catch (UnknownAmetysObjectException unknownAmetysObjectException) {
                // empty catch block
            }
        }
        infos.put("themes", themesList);
        return infos;
    }

    @Callable(rights={"LinkDirectory_Rights_Links_Handle"})
    public List<Map<String, Object>> getLinks(List<String> linkIds) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (String linkId : linkIds) {
            try {
                result.add(this.getLink(linkId));
            }
            catch (UnknownAmetysObjectException unknownAmetysObjectException) {}
        }
        return result;
    }

    protected boolean _urlExists(String url, String internalUrl, String siteName, String language) throws AmetysRepositoryException {
        boolean externalLinkExists = false;
        if (StringUtils.isNotBlank((CharSequence)url)) {
            String externalLinkXpathQuery = this._directoryHelper.getUrlExistsQuery(siteName, language, url);
            try (AmetysObjectIterable externalLinks = this._resolver.query(externalLinkXpathQuery);){
                externalLinkExists = externalLinks.iterator().hasNext();
            }
        }
        boolean internalLinkExists = false;
        if (StringUtils.isNotBlank((CharSequence)internalUrl)) {
            String internalLinkXpathQuery = this._directoryHelper.getUrlExistsQuery(siteName, language, internalUrl);
            try (AmetysObjectIterable internalLinks = this._resolver.query(internalLinkXpathQuery);){
                internalLinkExists = internalLinks.iterator().hasNext();
            }
        }
        return externalLinkExists || internalLinkExists;
    }

    protected boolean _urlExistsForUser(String url, String internalUrl, String siteName, String language, UserIdentity user) throws AmetysRepositoryException {
        boolean externalLinkExists = false;
        if (StringUtils.isNotBlank((CharSequence)url)) {
            String externalLinkXpathQuery = this._directoryHelper.getUrlExistsForUserQuery(siteName, language, url, user);
            try (AmetysObjectIterable externalLinks = this._resolver.query(externalLinkXpathQuery);){
                externalLinkExists = externalLinks.iterator().hasNext();
            }
        }
        boolean internalLinkExists = false;
        if (StringUtils.isNotBlank((CharSequence)internalUrl)) {
            String internalLinkXpathQuery = this._directoryHelper.getUrlExistsForUserQuery(siteName, language, internalUrl, user);
            try (AmetysObjectIterable internalLinks = this._resolver.query(internalLinkXpathQuery);){
                internalLinkExists = internalLinks.iterator().hasNext();
            }
        }
        return externalLinkExists || internalLinkExists;
    }

    protected DefaultLink _createLink(String name, ModifiableTraversableAmetysObject rootNode) {
        String originalName = NameHelper.filterName((String)name);
        Object uniqueName = originalName;
        int index = 2;
        while (rootNode.hasChild((String)uniqueName)) {
            uniqueName = originalName + "-" + index++;
        }
        return (DefaultLink)rootNode.createChild((String)uniqueName, "ametys:directoryLink");
    }

    private void _moveFirst(DefaultLink link) throws RepositoryException {
        try (AmetysObjectIterable children = ((TraversableAmetysObject)link.getParent()).getChildren();){
            link.orderBefore((AmetysObject)((TraversableAmetysObject)link.getParent()).getChildren().iterator().next());
            ((ModifiableAmetysObject)link.getParent()).saveChanges();
        }
    }

    private void _moveDown(DefaultLink link) throws RepositoryException {
        TraversableAmetysObject parentNode = (TraversableAmetysObject)link.getParent();
        AmetysObjectIterable siblings = parentNode.getChildren();
        AmetysObjectIterator it = siblings.iterator();
        boolean iterate = true;
        while (it.hasNext() && iterate) {
            DefaultLink sibling = (DefaultLink)it.next();
            iterate = !sibling.getName().equals(link.getName());
        }
        if (it.hasNext()) {
            DefaultLink nextLink = (DefaultLink)it.next();
            nextLink.orderBefore((AmetysObject)link);
            link.saveChanges();
        }
    }

    private void _moveUp(DefaultLink link) throws RepositoryException {
        DefaultLink sibling;
        TraversableAmetysObject parentNode = (TraversableAmetysObject)link.getParent();
        AmetysObjectIterable siblings = parentNode.getChildren();
        AmetysObjectIterator it = siblings.iterator();
        DefaultLink previousLink = null;
        while (it.hasNext() && !(sibling = (DefaultLink)it.next()).getName().equals(link.getName())) {
            previousLink = sibling;
        }
        if (previousLink != null) {
            link.orderBefore((AmetysObject)previousLink);
            link.saveChanges();
        }
    }

    private void _moveLast(DefaultLink link) throws RepositoryException {
        link.moveTo(link.getParent(), false);
        ((ModifiableAmetysObject)link.getParent()).saveChanges();
    }

    private void _setAccess(Link link, UserIdentity user) {
        if (user != null) {
            this._profileAssignmentStorageEP.allowProfileToUser(user, "READER", (Object)link);
        } else {
            this._profileAssignmentStorageEP.allowProfileToAnonymous("READER", (Object)link);
        }
        HashMap<String, Object> eventParams = new HashMap<String, Object>();
        eventParams.put("acl-context", link);
        eventParams.put("acl-profiles", Collections.singleton("READER"));
        this._observationManager.notify(new Event("acl.update", this._currentUserProvider.getUser(), eventParams));
    }

    public String getLinkColor(DefaultLink link) {
        Map colors = this._colorComponent.getColors(link.getSiteName());
        if (colors.containsKey(link.getColor())) {
            return (String)((Map)colors.get(link.getColor())).get("main");
        }
        return (String)((Map)colors.get(this._colorComponent.getDefaultKey(link.getSiteName()))).get("main");
    }
}

