/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class provides a widget to select one or more themes.<br>
 * See {@link  Ametys.plugins.linkdirectory.theme.ChooseTheme}<br>
 * 
 * This widget is registered for fields of type Ametys.form.WidgetManager#TYPE_STRING.
 */
Ext.define('Ametys.plugins.linkdirectory.theme.ThemeTag', {
    extend : 'Ametys.cms.form.widget.Tag',
    
    xtype: 'edition.select-link-theme',
    
    buttonIconCls: 'ametysicon-categories',
    
    buttonTooltipText : "{{i18n PLUGINS_LINKDIRECTORY_WIDGET_THEME_ADD_BUTTON_TOOLTIP}}",
    
    deleteTitle : "{{i18n PLUGINS_LINKDIRECTORY_WIDGET_THEME_DELETE_CONFIRM_TITLE}}",
    
    deleteConfirm : "{{i18n PLUGINS_LINKDIRECTORY_WIDGET_THEME_DELETE_CONFIRM_CONTENT}}",    
    
    emptyText: "{{i18n PLUGINS_LINKDIRECTORY_WIDGET_THEME_NO_THEME}}",
    
    plugin: 'workspaces',
    url: 'tags.json',
    
    /**
     * @cfg {String} [tagModel="Ametys.plugins.linkdirectory.theme.ThemeNode"] The id of model for tag nodes
     */ 
    tagModel: "Ametys.plugins.linkdirectory.theme.ThemeNode",
    
    /**
     * @cfg {String} [tagsDAO="org.ametys.plugins.linkdirectory.theme.ThemesDAO"] The DAO component to use for tags
     */ 
    tagsDAO: "org.ametys.plugins.linkdirectory.theme.ThemesDAO",
    
    /**
     * @cfg {String} dialogTitle The title of the dialog box to choose tag
     */ 
    /**
     * @cfg {String} dialogHelpMsg The help message to display on top of dialog box to choose tag
     */ 
    
    constructor: function (config)
    {
        config.url = config.url || 'themes.json';
        config.plugin = config.plugin || 'link-directory';
        
        this.callParent(arguments);
    },
    
    _showTagPopup : function() 
    {
        Ametys.plugins.linkdirectory.theme.ChooseTheme.open(this._getTagPopUpConfiguration());
    },
    
    _getTagsTitle: function(values, callback, scope)
    {
        Ametys.data.ServerComm.callMethod({
            role: this.tagsDAO, 
            methodName: 'getTagsTitle', 
            parameters: [values, this.getContextualParameters() ],
            errorMessage: "{{i18n plugin.cms:PLUGINS_CMS_HANDLE_TAGS_TAG_ERROR}}",
            callback: {
                handler: callback,
                scope: scope || this
            }
        });
    },
    
    _getTagPopUpConfiguration: function()
    {
        return Ext.apply(this.callParent(arguments), {
            plugin: this.plugin,
            url: this.url,
            tagModel: this.tagModel,
            tagsDAO: this.tagsDAO,
            title: this.dialogTitle || "{{i18n PLUGINS_LINKDIRECTORY_HELPER_CHOOSETHEME_TITLE}}",
            helpMessage: this.dialogHelpMsg || "{{i18n PLUGINS_LINKDIRECTORY_HELPER_CHOOSETHEME_HELP}}"
        });
    },
    
    getContextualParameters: function()
    {
        var contextualParameters = this.callParent(arguments);
        
        contextualParameters.language = this._getCurrentLanguage();
        return contextualParameters;
    },
    
    setLanguage: function (language)
    {
        this._language = language;
    },
    
    /**
     * @private
     * Get the current language for themes if available
     */
    _getCurrentLanguage: function()
    {
        if (this._language)
        {
            return this._language;
        }
        
        target = Ametys.message.MessageBus.getCurrentSelectionMessage().getTarget(Ametys.message.MessageTarget.PAGE);
        if (target != null)
        {
            return target.getParameters().lang;
        }
        
        // Then search in the directory tool.
        var directoryTool = Ametys.tool.ToolsManager.getTool('uitool-linkdirectory');
        if (directoryTool != null)
        {
            return directoryTool.getCurrentLanguage();
        }
        
        return Ametys.cms.language.LanguageDAO.getCurrentLanguage();
    }
    
})