<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2017 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    exclude-result-prefixes="ametys">
    
    <xsl:template name="add-link-bl">
        <xsl:param name="link-text">plugin.link-directory:PLUGINS_LINKDIRECTORY_BL_ADD_LINK</xsl:param>
        <xsl:param name="siteName"><xsl:value-of select="ametys:site()"/></xsl:param>
        <xsl:param name="lang"><xsl:value-of select="ametys:lang()"/></xsl:param>
        <xsl:param name="display-confirm">true</xsl:param>
        <xsl:param name="confirm-text">plugin.link-directory:PLUGINS_LINKDIRECTORY_BL_CONFIRM_TEXT</xsl:param>
        <xsl:param name="success-text">plugin.link-directory:PLUGINS_LINKDIRECTORY_BL_SUCCESS_TEXT</xsl:param>
        <xsl:param name="unauthenticated-user-text">plugin.link-directory:PLUGINS_LINKDIRECTORY_BL_ERROR_UNAUTHENTICATED_USER_TEXT</xsl:param>
        <xsl:param name="already-exists-text">plugin.link-directory:PLUGINS_LINKDIRECTORY_BL_ERROR_ALREADY_EXISTS_TEXT</xsl:param>
        <xsl:param name="unknown-error-text">plugin.link-directory:PLUGINS_LINKDIRECTORY_BL_ERROR_UNKNOWN_TEXT</xsl:param>
        <xsl:param name="custom-theme"></xsl:param>
        
        <a class="add-link-bl">
	        <xsl:attribute name="href">
		        <xsl:variable name="js">
		           <xsl:call-template name="bookmarklet-javascript">
		               <xsl:with-param name="siteName" select='$siteName'/>
		               <xsl:with-param name="lang" select='$lang'/>
		               <xsl:with-param name="display-confirm" select='$display-confirm'/>
		               <xsl:with-param name="confirm-text" select="$confirm-text"/>
		               <xsl:with-param name="success-text" select="$success-text"/>
		               <xsl:with-param name="unauthenticated-user-text" select="$unauthenticated-user-text"/>
		               <xsl:with-param name="already-exists-text" select="$already-exists-text"/>
		               <xsl:with-param name="unknown-error-text" select="$unknown-error-text"/>
		               <xsl:with-param name="custom-theme" select="$custom-theme" />
		           </xsl:call-template>
		        </xsl:variable>
		        <xsl:value-of select="normalize-space($js)"/>
	        </xsl:attribute>
	        <xsl:value-of select='ametys:translate($link-text)'/>
        </a>
    </xsl:template>
    
    <xsl:template name="bookmarklet-javascript">
        <xsl:param name="siteName"/>
        <xsl:param name="lang"/>
        <xsl:param name="display-confirm"/>
        <xsl:param name="confirm-text"/>
        <xsl:param name="success-text"/>
        <xsl:param name="unauthenticated-user-text"/>
        <xsl:param name="already-exists-text"/>
        <xsl:param name="unknown-error-text"/>
        <xsl:param name="custom-theme" />
        javascript:(function() {
            <xsl:if test="$display-confirm = 'true'">
            if (confirm("<xsl:value-of select='ametys:translate($confirm-text)'/>"))
            {
            </xsl:if>
	            var linkTitle = document.title;
	            var linkUrl = document.URL;
	            var url = '<xsl:value-of select="ametys:absoluteSiteUriPrefix()"/>/_plugins/link-directory/add-user-link?siteName=<xsl:value-of select="$siteName"/>&amp;lang=<xsl:value-of select="$lang"/>&amp;url=' + encodeURIComponent(linkUrl) + '&amp;title=' + encodeURIComponent(linkTitle) + '&amp;themes=<xsl:value-of select="$custom-theme" />';
	            var req = new XMLHttpRequest();
	            
				req.open('GET', url, true);
				req.withCredentials = true;
				req.onreadystatechange = function(aEvt)
				{
				    if (req.readyState == 4)
				    {
				        if (req.status == 200 &amp;&amp; req.responseText)
				        {
				            var error = JSON.parse(req.responseText).error;
				            switch(error)
				            {
				                case "none":
					               alert("<xsl:copy-of select="ametys:translate($success-text)"/>");
					               break;
				                case "already-exists":
				                    alert("<xsl:copy-of select="ametys:translate($already-exists-text)"/>");
					                break;
				                case "unauthenticated-user":
				                    alert("<xsl:copy-of select="ametys:translate($unauthenticated-user-text)"/>");
					                break;
					            default:
					                alert("<xsl:copy-of select="ametys:translate($unknown-error-text)"/>");
					        }
				        }
				        else
				        {
				            <!-- Cannot read the response -->
				            alert("<xsl:copy-of select="ametys:translate($unknown-error-text)"/>");
				        }
				    }
				};
				req.send(null);
            <xsl:if test="$display-confirm = 'true'">
			}
			</xsl:if>
            return void(0);
        })();
    </xsl:template>
</xsl:stylesheet>
