/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.linkdirectory.dynamic;

/**
 * Common exception for dynamic information
 */
public class DynamicInformationException extends RuntimeException
{
    /**
     * Enum for type of exception
     */
    public enum ExceptionType
    {
        /** The connection is not authorized */
        UNAUTHORIZED,
        /** Connection timed out */
        TIMEOUT,
        /** Configuration exception (unknown host, host unreachable, 404, ...) */
        CONFIGURATION_EXCEPTION,
        /** Nothing defined */
        UNKNOWN;
    }
    
    private ExceptionType _type = ExceptionType.UNKNOWN;
    
    private boolean _silent;
    
    /**
     * Constructs a new exception with the specified detail message.
     * @param message the detail message.
     * @param type reason of the exception
     */
    public DynamicInformationException(String message, ExceptionType type)
    {
        this(message, type, null, true);
    }

    /**
     * Constructs a new exception with the specified detail message and cause.
     * @param message the detail message.
     * @param cause the cause.
     */
    public DynamicInformationException(String message, Throwable cause)
    {
        this(message, ExceptionType.UNKNOWN, cause, false);
    }
    
    /**
     * Constructs a new exception with the specified detail message and cause.
     * @param message the detail message.
     * @param type reason of the exception
     * @param cause the cause.
     */
    public DynamicInformationException(String message, ExceptionType type, Throwable cause)
    {
        this(message, type, cause, false);
    }

    /**
     * Constructs a new exception with the specified detail message and cause.
     * @param message the detail message.
     * @param type reason of the exception
     * @param cause the cause.
     * @param silent if true, indicates to not log errors
     */
    public DynamicInformationException(String message, ExceptionType type, Throwable cause, boolean silent)
    {
        super(message, cause);
        _type = type;
        _silent = silent;
    }

    /**
     * Get the type of exception
     * @return {@link ExceptionType}
     */
    public ExceptionType getType()
    {
        return _type;
    }
    
    /**
     * Returns true if this exception should not be logged as an error
     * @return true if in silent mode
     */
    public boolean isSilent()
    {
        return _silent;
    }
}
