/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.linkdirectory.repository;

import org.ametys.runtime.model.type.ModelItemType;

/**
 * Extension point holding all {@link ModelItemType} classes for needing features.
 */
public class ModelItemTypeExtensionPoint extends org.ametys.web.data.type.ModelItemTypeExtensionPoint
{
    /** Avalon Role for link data types */
    public static final String ROLE_LINK_DATA = ModelItemTypeExtensionPoint.class.getName() + ".LinkData";
}
