/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.mobileapp.action;

import java.util.HashMap;
import java.util.Map;

import org.apache.cocoon.environment.Request;

import org.ametys.core.cocoon.JSonReader;

/**
 * test if the API accepts anonymous users
 */
public class GetAuthAction extends AbstractLoggedAction
{
    /** value when the user have to be authentified */
    private static final String __AUTHENTIFIED = "authentified";
    
    @Override
    protected Map<String, Object> doLoggedInAction(Request request, Map<String, Object> jsonParams)
    {
        Map<String, Object> result = new HashMap<>();
        
        result.put("response", __AUTHENTIFIED);
        
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return result;
    }
}
