/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.mobileapp.action;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

import org.apache.cocoon.environment.Request;

import org.ametys.runtime.i18n.I18nizableText;

/**
 * Returns the list of feeds for a user
 */
public class GetEventTypesAction extends AbstractLoggedAction
{
    /** Allowed event types for push notifications */
    public static final Map<String, Object> EVENT_TYPES = new LinkedHashMap<>();
    
    static
    {
        EVENT_TYPES.put("project.news.published", new I18nizableText("plugin.mobileapp", "PLUGINS_MOBILEAPP_WORKSPACES_EVENT_TYPES_PROJECT_NEWS_PUBLISHED"));
        EVENT_TYPES.put("wallcontent.added", new I18nizableText("plugin.mobileapp", "PLUGINS_MOBILEAPP_WORKSPACES_EVENT_TYPES_WALLCONTENT_ADDED"));
        EVENT_TYPES.put("member.added", new I18nizableText("plugin.mobileapp", "PLUGINS_MOBILEAPP_WORKSPACES_EVENT_TYPES_MEMBER_ADDED"));
        EVENT_TYPES.put("resource.created", new I18nizableText("plugin.mobileapp", "PLUGINS_MOBILEAPP_WORKSPACES_EVENT_TYPES_RESOURCE_CREATED"));
        EVENT_TYPES.put("forumthread.created", new I18nizableText("plugin.mobileapp", "PLUGINS_MOBILEAPP_WORKSPACES_EVENT_TYPES_FORUMTHREAD_CREATED"));
        EVENT_TYPES.put("forumthread.commented", new I18nizableText("plugin.mobileapp", "PLUGINS_MOBILEAPP_WORKSPACES_EVENT_TYPES_FORUMTHREAD_COMMENTED"));
        EVENT_TYPES.put("calendar.event.created", new I18nizableText("plugin.mobileapp", "PLUGINS_MOBILEAPP_WORKSPACES_EVENT_TYPES_CALENDAR_EVENT_CREATED"));
        EVENT_TYPES.put("task.created", new I18nizableText("plugin.mobileapp", "PLUGINS_MOBILEAPP_WORKSPACES_EVENT_TYPES_TASK_CREATED"));
    }
    
    @Override
    protected Map<String, Object> doLoggedInAction(Request request, Map<String, Object> jsonParams)
    {
        Map<String, Object> result = new HashMap<>();
        result.put("types", EVENT_TYPES);
        return result;
    }
}
