/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.newsletter.auto;

import com.opensymphony.workflow.InvalidActionException;
import com.opensymphony.workflow.WorkflowException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.cms.filter.ContentFilter;
import org.ametys.cms.filter.ContentFilterExtensionPoint;
import org.ametys.cms.filter.ContentFilterHelper;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.cms.workflow.AbstractContentWorkflowComponent;
import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.core.util.I18nUtils;
import org.ametys.plugins.core.impl.schedule.AbstractStaticSchedulable;
import org.ametys.plugins.newsletter.auto.AutomaticNewsletter;
import org.ametys.plugins.newsletter.auto.AutomaticNewsletterExtensionPoint;
import org.ametys.plugins.newsletter.auto.AutomaticNewsletterFilterResult;
import org.ametys.plugins.newsletter.category.Category;
import org.ametys.plugins.newsletter.category.CategoryProvider;
import org.ametys.plugins.newsletter.category.CategoryProviderExtensionPoint;
import org.ametys.plugins.newsletter.workflow.CreateNewsletterFunction;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.provider.RequestAttributeWorkspaceSelector;
import org.ametys.plugins.workflow.AbstractWorkflowComponent;
import org.ametys.plugins.workflow.component.CheckRightsCondition;
import org.ametys.plugins.workflow.repository.WorkflowAwareAmetysObject;
import org.ametys.plugins.workflow.support.WorkflowProvider;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.filter.WebContentFilter;
import org.ametys.web.filter.WebContentFilterHelper;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.ametys.web.repository.sitemap.Sitemap;
import org.ametys.web.workflow.CreateContentFunction;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;
import org.quartz.JobExecutionContext;

public class AutomaticNewslettersSchedulable
extends AbstractStaticSchedulable {
    protected static final String _NEWSLETTER_CONTENT_TYPE = "org.ametys.plugins.newsletter.Content.newsletter";
    protected Date _runDate;
    protected String _workflowName;
    protected int _wfInitialActionId;
    protected List<Integer> _wfValidateActionIds;
    protected Map<String, List<String>> _filterContentIdCache;
    protected AmetysObjectResolver _resolver;
    protected SiteManager _siteManager;
    protected WorkflowProvider _workflowProvider;
    protected AutomaticNewsletterExtensionPoint _autoNewsletterEP;
    protected CategoryProviderExtensionPoint _categoryEP;
    protected ContentFilterExtensionPoint _contentFilterEP;
    protected WebContentFilterHelper _contentFilterHelper;
    protected I18nUtils _i18nUtils;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._siteManager = (SiteManager)manager.lookup(SiteManager.ROLE);
        this._workflowProvider = (WorkflowProvider)manager.lookup(WorkflowProvider.ROLE);
        this._autoNewsletterEP = (AutomaticNewsletterExtensionPoint)((Object)manager.lookup(AutomaticNewsletterExtensionPoint.ROLE));
        this._categoryEP = (CategoryProviderExtensionPoint)((Object)manager.lookup(CategoryProviderExtensionPoint.ROLE));
        this._contentFilterEP = (ContentFilterExtensionPoint)manager.lookup(ContentFilterExtensionPoint.ROLE);
        this._contentFilterHelper = (WebContentFilterHelper)manager.lookup(ContentFilterHelper.ROLE);
        this._i18nUtils = (I18nUtils)manager.lookup(I18nUtils.ROLE);
        this._filterContentIdCache = new HashMap<String, List<String>>();
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        Configuration workflowConf = configuration.getChild("workflow");
        this._workflowName = workflowConf.getAttribute("name");
        this._wfInitialActionId = workflowConf.getAttributeAsInteger("initialActionId");
        String[] validateActionIds = StringUtils.split((String)workflowConf.getAttribute("validateActionIds"), (String)", ");
        this._wfValidateActionIds = new ArrayList<Integer>(validateActionIds.length);
        for (String actionId : validateActionIds) {
            try {
                this._wfValidateActionIds.add(Integer.valueOf(actionId));
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException("Invalid validation action ID.", (Throwable)e);
            }
        }
    }

    public void execute(JobExecutionContext context, ContainerProgressionTracker progressionTracker) throws Exception {
        this._runDate = new Date();
        this._filterContentIdCache.clear();
        try (AmetysObjectIterable sites = this._siteManager.getSites();){
            for (Site site : sites) {
                AmetysObjectIterable sitemaps = site.getSitemaps();
                try {
                    for (Sitemap sitemap : sitemaps) {
                        this.createAutomaticNewsletters(site.getName(), sitemap.getName());
                    }
                }
                finally {
                    if (sitemaps == null) continue;
                    sitemaps.close();
                }
            }
        }
    }

    protected void createAutomaticNewsletters(String siteName, String sitemapName) {
        Request request = ContextHelper.getRequest((Context)this._context);
        request.setAttribute("Runtime:InternalAllowedRequest", (Object)true);
        request.setAttribute("siteName", (Object)siteName);
        for (String providerId : this._categoryEP.getExtensionsIds()) {
            CategoryProvider provider = (CategoryProvider)this._categoryEP.getExtension(providerId);
            for (Category category : provider.getAllCategories(siteName, sitemapName)) {
                Collection<String> automaticIds = provider.getAutomaticIds(category.getId());
                for (String autoNewsletterId : automaticIds) {
                    AutomaticNewsletter autoNewsletter = (AutomaticNewsletter)this._autoNewsletterEP.getExtension(autoNewsletterId);
                    if (autoNewsletter == null || !this.createNow(autoNewsletter)) continue;
                    this.createAndValidateAutomaticNewsletter(siteName, sitemapName, category, provider, autoNewsletter);
                }
            }
        }
    }

    protected void createAndValidateAutomaticNewsletter(String siteName, String sitemapName, Category category, CategoryProvider provider, AutomaticNewsletter autoNewsletter) {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Preparing to create an automatic newsletter for category " + category.getId() + " in " + siteName + " and sitemap " + sitemapName);
        }
        Map<String, AutomaticNewsletterFilterResult> contentsByFilter = this.getFilterResults(siteName, sitemapName, autoNewsletter);
        try {
            if (this.hasResults(contentsByFilter.values())) {
                long nextNumber = this.getNextNumber(category, provider, siteName, sitemapName);
                WorkflowAwareContent content = this.createNewsletterContent(siteName, sitemapName, category, autoNewsletter, nextNumber, contentsByFilter);
                this.validateNewsletter(content);
            } else if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("No content has been returned by the filters for the automatic newsletter in category " + category.getId() + " in site " + siteName + " and sitemap " + sitemapName + ": no newsletter has been created.");
            }
        }
        catch (InvalidActionException | WorkflowException e) {
            this.getLogger().error("Unable to create and validate an automatic newsletter for category " + category.getId() + " in site " + siteName + " and sitemap " + sitemapName, e);
        }
    }

    protected Map<String, AutomaticNewsletterFilterResult> getFilterResults(String siteName, String sitemapName, AutomaticNewsletter autoNewsletter) {
        HashMap<String, AutomaticNewsletterFilterResult> contentsByFilter = new HashMap<String, AutomaticNewsletterFilterResult>();
        Request request = ContextHelper.getRequest((Context)this._context);
        Map<String, String> filters = autoNewsletter.getFilters();
        for (String name : filters.keySet()) {
            String filterId = filters.get(name);
            AutomaticNewsletterFilterResult result = new AutomaticNewsletterFilterResult();
            contentsByFilter.put(name, result);
            List<String> contentIds = new ArrayList<String>();
            ContentFilter filter = (ContentFilter)this._contentFilterEP.getExtension(filterId);
            if (filter != null && filter instanceof WebContentFilter) {
                WebContentFilter webFilter = (WebContentFilter)filter;
                result.setViewName(filter.getView());
                String cacheKey = siteName + "/" + sitemapName + "/" + filterId;
                if (this._filterContentIdCache.containsKey(cacheKey)) {
                    contentIds = this._filterContentIdCache.get(cacheKey);
                } else {
                    String originalWorkspace = RequestAttributeWorkspaceSelector.getForcedWorkspace((Request)request);
                    RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)"live");
                    contentIds = this._contentFilterHelper.getMatchingContentIds(webFilter, siteName, sitemapName, null);
                    RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)originalWorkspace);
                    this._filterContentIdCache.put(cacheKey, contentIds);
                }
            }
            result.setContentIds(contentIds);
        }
        return contentsByFilter;
    }

    protected WorkflowAwareContent createNewsletterContent(String siteName, String language, Category category, AutomaticNewsletter autoNewsletter, long newsletterNumber, Map<String, AutomaticNewsletterFilterResult> filterResults) throws WorkflowException {
        String contentName = category.getName() + "-" + newsletterNumber;
        String title = this.getNewsletterTitle(language, category, autoNewsletter, newsletterNumber);
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap workflowResult = new HashMap();
        params.put(AbstractWorkflowComponent.RESULT_MAP_KEY, workflowResult);
        params.put("workflowName", this._workflowName);
        params.put(CreateContentFunction.SITE_KEY, siteName);
        params.put(org.ametys.cms.workflow.CreateContentFunction.CONTENT_NAME_KEY, contentName);
        params.put(org.ametys.cms.workflow.CreateContentFunction.CONTENT_TITLE_KEY, title);
        params.put(org.ametys.cms.workflow.CreateContentFunction.CONTENT_TYPES_KEY, new String[]{_NEWSLETTER_CONTENT_TYPE});
        params.put(org.ametys.cms.workflow.CreateContentFunction.CONTENT_LANGUAGE_KEY, language);
        params.put(CreateNewsletterFunction.NEWSLETTER_CATEGORY_KEY, category.getId());
        params.put(CreateNewsletterFunction.NEWSLETTER_NUMBER_KEY, newsletterNumber);
        params.put(CreateNewsletterFunction.NEWSLETTER_DATE_KEY, this._runDate);
        params.put(CreateNewsletterFunction.NEWSLETTER_IS_AUTOMATIC_KEY, "true");
        params.put(CreateNewsletterFunction.NEWSLETTER_PROCESS_AUTO_SECTIONS_KEY, "true");
        params.put(CreateNewsletterFunction.NEWSLETTER_CONTENT_ID_MAP_KEY, filterResults);
        WorkflowProvider.AmetysObjectWorkflow workflow = this._workflowProvider.getAmetysObjectWorkflow();
        workflow.initialize(this._workflowName, this._wfInitialActionId, params);
        WorkflowAwareContent content = (WorkflowAwareContent)workflowResult.get(AbstractContentWorkflowComponent.CONTENT_KEY);
        return content;
    }

    protected void validateNewsletter(WorkflowAwareContent newsletterContent) throws WorkflowException {
        long workflowId = newsletterContent.getWorkflowId();
        HashMap<String, Object> inputs = new HashMap<String, Object>();
        inputs.put(AbstractContentWorkflowComponent.CONTENT_KEY, newsletterContent);
        inputs.put("send-mail", "false");
        inputs.put(CheckRightsCondition.FORCE, true);
        Request request = ContextHelper.getRequest((Context)this._context);
        request.setAttribute("send", (Object)"true");
        WorkflowProvider.AmetysObjectWorkflow workflow = this._workflowProvider.getAmetysObjectWorkflow((WorkflowAwareAmetysObject)newsletterContent);
        for (Integer actionId : this._wfValidateActionIds) {
            workflow.doAction(workflowId, actionId.intValue(), inputs);
        }
    }

    protected String getNewsletterTitle(String language, Category category, AutomaticNewsletter autoNewsletter, long newsletterNumber) {
        Object title = "";
        I18nizableText newsletterTitle = autoNewsletter.getNewsletterTitle();
        if (newsletterTitle == null || StringUtils.isEmpty((CharSequence)newsletterTitle.toString())) {
            String categoryTitle = this._i18nUtils.translate((I18nizable)category.getTitle(), language);
            title = categoryTitle + " " + newsletterNumber;
        } else if (newsletterTitle.isI18n()) {
            Map<String, I18nizableText> params = Collections.singletonMap("number", new I18nizableText(Long.toString(newsletterNumber)));
            I18nizableText titleI18n = new I18nizableText(newsletterTitle.getCatalogue(), newsletterTitle.getKey(), params);
            title = this._i18nUtils.translate((I18nizable)titleI18n, language);
        } else {
            title = newsletterTitle.getLabel();
            title = ((String)title).contains("{number}") ? ((String)title).replaceAll("\\{number\\}", String.valueOf(newsletterNumber)) : (String)title + " " + newsletterNumber;
        }
        return title;
    }

    protected long getNextNumber(Category category, CategoryProvider provider, String siteName, String language) {
        long number = 0L;
        try (AmetysObjectIterable<Content> newsletters = provider.getNewsletters(category.getId(), siteName, language);){
            for (Content newsletterContent : newsletters) {
                long contentNumber = (Long)newsletterContent.getValue("newsletter-number", false, (Object)0L);
                number = Math.max(number, contentNumber);
            }
            long l = number + 1L;
            return l;
        }
    }

    protected boolean hasResults(Collection<AutomaticNewsletterFilterResult> results) {
        boolean hasResults = false;
        for (AutomaticNewsletterFilterResult result : results) {
            if (!result.hasResults()) continue;
            hasResults = true;
        }
        return hasResults;
    }

    protected boolean createNow(AutomaticNewsletter autoNewsletter) {
        boolean createToday = false;
        ZonedDateTime runDate = this._runDate.toInstant().atZone(ZoneId.systemDefault());
        Collection<Integer> dayNumbers = autoNewsletter.getDayNumbers();
        switch (autoNewsletter.getFrequencyType()) {
            case MONTH: {
                createToday = this.testMonth(dayNumbers, runDate);
                break;
            }
            case WEEK: {
                createToday = this.testWeek(dayNumbers, runDate);
                break;
            }
        }
        return createToday;
    }

    protected boolean testMonth(Collection<Integer> dayNumbers, ZonedDateTime runDate) {
        boolean createToday = false;
        int dayOfMonth = runDate.getDayOfMonth();
        int lastDayOfMonth = runDate.with(TemporalAdjusters.lastDayOfMonth()).getDayOfMonth();
        for (Integer dayNumber : dayNumbers) {
            if (dayNumber == dayOfMonth) {
                createToday = true;
                continue;
            }
            if (dayNumber <= lastDayOfMonth || dayOfMonth != lastDayOfMonth) continue;
            createToday = true;
        }
        return createToday;
    }

    protected boolean testWeek(Collection<Integer> dayNumbers, ZonedDateTime runDate) {
        boolean createToday = false;
        int dayOfWeek = runDate.getDayOfWeek().getValue();
        for (Integer dayNumber : dayNumbers) {
            if (dayNumber != dayOfWeek) continue;
            createToday = true;
        }
        return createToday;
    }
}

