/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.newsletter.category;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.cms.repository.Content;
import org.ametys.plugins.newsletter.category.Category;
import org.ametys.plugins.newsletter.category.CategoryProvider;
import org.ametys.plugins.newsletter.category.CategoryProviderExtensionPoint;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class CategoryGenerator
extends ServiceableGenerator {
    protected AmetysObjectResolver _resolver;
    protected CategoryProviderExtensionPoint _categoryProviderEP;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._categoryProviderEP = (CategoryProviderExtensionPoint)((Object)serviceManager.lookup(CategoryProviderExtensionPoint.ROLE));
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"categories");
        Map jsParameters = (Map)this.objectModel.get("parent-context");
        List categoryIDs = (List)jsParameters.get("id");
        this.saxCategories(categoryIDs);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"categories");
        this.contentHandler.endDocument();
    }

    protected void saxCategories(List<String> categoryIDs) throws SAXException {
        Set ids = this._categoryProviderEP.getExtensionsIds();
        for (String categoryID : categoryIDs) {
            for (String id : ids) {
                CategoryProvider provider = (CategoryProvider)this._categoryProviderEP.getExtension(id);
                if (!provider.hasCategory(categoryID)) continue;
                Category category = provider.getCategory(categoryID);
                this.saxCategory(provider, category, false, false);
            }
        }
    }

    protected void saxCategory(CategoryProvider provider, Category category, boolean children, boolean newsletter) throws SAXException {
        String id = category.getId();
        I18nizableText title = category.getTitle();
        I18nizableText description = category.getDescription();
        String template = category.getTemplate();
        String siteName = category.getSiteName();
        String lang = category.getLang();
        Collection<String> automaticIds = provider.getAutomaticIds(id);
        AttributesImpl attr = new AttributesImpl();
        attr.addAttribute("", "id", "id", "CDATA", category.getId());
        attr.addAttribute("", "parentId", "parentId", "CDATA", category.getParentId());
        attr.addAttribute("", "name", "name", "CDATA", category.getName());
        attr.addAttribute("", "siteName", "siteName", "CDATA", category.getSiteName());
        attr.addAttribute("", "lang", "lang", "CDATA", category.getLang());
        if (provider.hasChildren(id) || provider.hasNewsletters(id, siteName, lang)) {
            attr.addAttribute("", "hasChild", "hasChild", "CDATA", "true");
        }
        attr.addAttribute("", "mode", "mode", "CDATA", provider.isWritable() ? "write" : "read");
        attr.addCDATAAttribute("automaticIds", StringUtils.join(automaticIds, (char)','));
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"category", (Attributes)attr);
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"title");
        title.toSAX(this.contentHandler);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"title");
        if (description != null) {
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"description");
            description.toSAX(this.contentHandler);
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"description");
        }
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"template", (String)(template != null ? template : ""));
        if (children) {
            List<Category> childCategories = provider.getCategories(category.getId());
            for (Category child : childCategories) {
                this.saxCategory(provider, child, false, false);
            }
        }
        if (newsletter) {
            AmetysObjectIterable<Content> contents = provider.getNewsletters(id, siteName, lang);
            this.saxNewsletters(contents);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"category");
    }

    protected void saxNewsletters(AmetysObjectIterable<Content> newsletters) throws SAXException {
        for (Content content : newsletters) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", "id", "id", "CDATA", content.getId());
            attrs.addAttribute("", "name", "name", "CDATA", content.getName());
            attrs.addAttribute("", "title", "title", "CDATA", content.getTitle());
            boolean automatic = (Boolean)content.getInternalDataHolder().getValue("automatic", (Object)false);
            attrs.addAttribute("", "automatic", "automatic", "CDATA", String.valueOf(automatic));
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"newsletter", (Attributes)attrs);
        }
    }
}

