/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.newsletter.category;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.plugins.newsletter.category.Category;
import org.ametys.plugins.newsletter.category.CategoryGenerator;
import org.ametys.plugins.newsletter.category.CategoryProvider;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class NewslettersTreeGenerator
extends CategoryGenerator {
    @Override
    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String categoryID = request.getParameter("categoryID");
        String siteName = request.getParameter("sitename");
        String lang = request.getParameter("lang");
        boolean categoriesOnly = this.parameters.getParameterAsBoolean("categoriesOnly", false);
        this.contentHandler.startDocument();
        if (StringUtils.isEmpty((CharSequence)categoryID) || "root".equals(categoryID)) {
            AttributesImpl attr = new AttributesImpl();
            attr.addAttribute("", "id", "id", "CDATA", "root");
            attr.addAttribute("", "hasChild", "hasChild", "CDATA", "true");
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"provider", (Attributes)attr);
            Set ids = this._categoryProviderEP.getExtensionsIds();
            for (String id : ids) {
                CategoryProvider provider = (CategoryProvider)this._categoryProviderEP.getExtension(id);
                this.saxProvider(provider, siteName, lang, false);
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"provider");
        } else if (categoryID.startsWith("provider_")) {
            String id = categoryID.substring("provider_".length());
            CategoryProvider provider = (CategoryProvider)this._categoryProviderEP.getExtension(id);
            this.saxProvider(provider, siteName, lang, true);
        } else {
            Set ids = this._categoryProviderEP.getExtensionsIds();
            for (String id : ids) {
                CategoryProvider provider = (CategoryProvider)this._categoryProviderEP.getExtension(id);
                if (!provider.hasCategory(categoryID)) continue;
                Category category = provider.getCategory(categoryID);
                this.saxCategory(provider, category, true, !categoriesOnly);
            }
        }
        this.contentHandler.endDocument();
    }

    protected void saxProvider(CategoryProvider provider, String siteName, String lang, boolean children) throws SAXException {
        String id = provider.getId();
        I18nizableText title = provider.getLabel();
        I18nizableText description = provider.getDescription();
        AttributesImpl attr = new AttributesImpl();
        attr.addAttribute("", "id", "id", "CDATA", "provider_" + id);
        List<Category> childCategories = provider.getCategories(siteName, lang);
        if (childCategories.size() > 0) {
            attr.addAttribute("", "hasChild", "hasChild", "CDATA", "true");
        }
        attr.addAttribute("", "mode", "mode", "CDATA", provider.isWritable() ? "write" : "read");
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"provider", (Attributes)attr);
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"title");
        title.toSAX(this.contentHandler);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"title");
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"description");
        description.toSAX(this.contentHandler);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"description");
        if (children) {
            for (Category child : childCategories) {
                this.saxCategory(provider, child, false, false);
            }
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"provider");
    }
}

