/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.newsletter.generators;

import java.io.IOException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.Map;
import java.util.Optional;
import org.ametys.cms.content.ContentHelper;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ContentTypeExpression;
import org.ametys.core.util.DateUtils;
import org.ametys.core.util.FilenameUtils;
import org.ametys.core.util.IgnoreRootHandler;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.newsletter.category.Category;
import org.ametys.plugins.newsletter.category.CategoryProviderExtensionPoint;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectIterator;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.provider.RequestAttributeWorkspaceSelector;
import org.ametys.plugins.repository.query.QueryHelper;
import org.ametys.plugins.repository.query.SortCriteria;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.ExpressionContext;
import org.ametys.plugins.repository.query.expression.MetadataExpression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.runtime.model.type.ElementType;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.impl.SitemapSource;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class NewsletterListGenerator
extends ServiceableGenerator {
    protected CategoryProviderExtensionPoint _categoryProviderEP;
    protected SourceResolver _sourceResolver;
    private AmetysObjectResolver _resolver;
    private ContentHelper _contentHelper;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._sourceResolver = (SourceResolver)smanager.lookup(SourceResolver.ROLE);
        this._categoryProviderEP = (CategoryProviderExtensionPoint)((Object)smanager.lookup(CategoryProviderExtensionPoint.ROLE));
        this._contentHelper = (ContentHelper)smanager.lookup(ContentHelper.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String workspaceName = RequestAttributeWorkspaceSelector.getForcedWorkspace((Request)request);
        RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)"live");
        String siteName = this.parameters.getParameter("siteName", (String)request.getAttribute("site"));
        String categoryId = this.parameters.getParameter("category", null);
        String encodedCategoryId = this.parameters.getParameter("encodedCategoryId", null);
        boolean saxNewsletterContent = this.parameters.getParameterAsBoolean("newsletterContent", false);
        String header = this.parameters.getParameter("header", "");
        int length = this.parameters.getParameterAsInteger("length", 0);
        boolean displayRss = this.parameters.getParameterAsBoolean("rss", false);
        if (categoryId == null && StringUtils.isNotEmpty((CharSequence)encodedCategoryId)) {
            categoryId = URIUtils.decode((String)encodedCategoryId);
        }
        ExpressionContext expressionContextForInternal = ExpressionContext.newInstance().withInternal(true);
        ContentTypeExpression cTypeExpr = new ContentTypeExpression(Expression.Operator.EQ, new String[]{"org.ametys.plugins.newsletter.Content.newsletter"});
        MetadataExpression validExpr = new MetadataExpression("lastValidationDate", expressionContextForInternal);
        StringExpression siteExpr = new StringExpression("site", Expression.Operator.EQ, siteName, expressionContextForInternal);
        StringExpression categoryExpr = new StringExpression("category", Expression.Operator.EQ, categoryId, expressionContextForInternal);
        AndExpression expression = new AndExpression(new Expression[]{cTypeExpr, validExpr, siteExpr, categoryExpr});
        SortCriteria sortCriteria = new SortCriteria();
        sortCriteria.addJCRPropertyCriterion("ametys-internal:lastValidationDate", false, false);
        String xpathQuery = QueryHelper.getXPathQuery(null, (String)"ametys:content", (Expression)expression, (SortCriteria)sortCriteria);
        try (AmetysObjectIterable contents = this._resolver.query(xpathQuery);){
            AttributesImpl attrs = new AttributesImpl();
            if (StringUtils.isNotEmpty((CharSequence)header)) {
                attrs.addCDATAAttribute("service-title", header);
            }
            Category category = categoryId != null ? this._categoryProviderEP.getCategory(categoryId) : null;
            this.contentHandler.startDocument();
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"Newsletters", (Attributes)attrs);
            if (category != null) {
                this._saxCategory(category);
            }
            AmetysObjectIterator it = contents.iterator();
            for (int index = 0; it.hasNext() && index < length; ++index) {
                Content content = (Content)it.next();
                this._saxNewsletter(content, saxNewsletterContent);
            }
            if (displayRss && category != null) {
                this._saxRssFeed(category);
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"Newsletters");
            this.contentHandler.endDocument();
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)workspaceName);
        }
    }

    protected void _saxCategory(Category category) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("id", category.getId());
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"category", (Attributes)attrs);
        category.getTitle().toSAX(this.contentHandler, "title");
        category.getDescription().toSAX(this.contentHandler, "description");
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"category");
    }

    private void _saxNewsletter(Content content, boolean saxContent) throws SAXException, IOException {
        AttributesImpl attr = new AttributesImpl();
        attr.addAttribute("", "id", "id", "CDATA", content.getId());
        attr.addAttribute("", "name", "name", "CDATA", content.getName());
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"newsletter", (Attributes)attr);
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"title", (String)content.getTitle());
        long number = (Long)content.getValue("newsletter-number", false, (Object)0L);
        if (number != 0L) {
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"number", (String)String.valueOf(number));
        }
        LocalDate defaultValue = Optional.ofNullable(content.getLastMajorValidationDate()).map(ChronoZonedDateTime::toInstant).map(DateUtils::asLocalDate).orElse(null);
        LocalDate date = (LocalDate)content.getValue("newsletter-date", false, (Object)defaultValue);
        ElementType dateType = (ElementType)content.getType("newsletter-date");
        AttributesImpl dateAttrs = new AttributesImpl();
        Long millis = date.atStartOfDay(ZoneId.systemDefault()).toInstant().toEpochMilli();
        dateAttrs.addCDATAAttribute("millis", Long.toString(millis));
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"date", (Attributes)dateAttrs, (String)dateType.toString((Object)date));
        ZonedDateTime pubDate = content.getLastMajorValidationDate();
        dateAttrs.clear();
        dateAttrs.addCDATAAttribute("millis", Long.toString(pubDate.toInstant().toEpochMilli()));
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"pubDate", (Attributes)dateAttrs, (String)DateUtils.zonedDateTimeToString((ZonedDateTime)pubDate));
        if (saxContent) {
            this._saxNewsletterContent(content);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"newsletter");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _saxNewsletterContent(Content content) throws SAXException, IOException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"newsletter-content");
        String uri = this._contentHelper.getContentViewUrl(content, "main", "xml");
        SitemapSource src = null;
        try {
            src = (SitemapSource)this._sourceResolver.resolveURI(uri);
            src.toSAX((ContentHandler)new IgnoreRootHandler(this.contentHandler));
        }
        finally {
            this._sourceResolver.release((Source)src);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"newsletter-content");
    }

    protected void _saxRssFeed(Category category) throws SAXException, ProcessingException {
        String categoryId = category.getId();
        String siteName = category.getSiteName();
        String lang = category.getLang();
        String encodedCategoryId = FilenameUtils.encodePath((String)categoryId);
        String url = "plugins/newsletter/" + siteName + "/" + lang + "/archives/" + encodedCategoryId + "/rss.xml";
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("url", URIUtils.encodePath((String)url));
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"rss", (Attributes)attrs);
    }
}

