/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.newsletter.subscribe;

import java.util.Date;
import java.util.Set;
import java.util.UUID;
import org.ametys.core.captcha.CaptchaHelper;
import org.ametys.core.util.mail.SendMailHelper;
import org.ametys.plugins.newsletter.category.Category;
import org.ametys.plugins.newsletter.category.CategoryProvider;
import org.ametys.plugins.newsletter.category.CategoryProviderExtensionPoint;
import org.ametys.plugins.newsletter.daos.Subscriber;
import org.ametys.plugins.newsletter.daos.SubscribersDAO;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.web.cache.PageHelper;
import org.ametys.web.repository.page.SitemapElement;
import org.ametys.web.site.SiteConfigurationExtensionPoint;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractSubscribeAction
extends ServiceableAction
implements ThreadSafe {
    protected SubscribersDAO _subscribersDao;
    protected CategoryProviderExtensionPoint _categoryProviderEP;
    protected SiteConfigurationExtensionPoint _siteConfiguration;
    protected AmetysObjectResolver _resolver;
    protected PageHelper _pageHelper;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._subscribersDao = (SubscribersDAO)((Object)smanager.lookup(SubscribersDAO.ROLE));
        this._categoryProviderEP = (CategoryProviderExtensionPoint)((Object)smanager.lookup(CategoryProviderExtensionPoint.ROLE));
        this._siteConfiguration = (SiteConfigurationExtensionPoint)smanager.lookup(SiteConfigurationExtensionPoint.ROLE);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._pageHelper = (PageHelper)smanager.lookup(PageHelper.ROLE);
    }

    protected boolean _validEmail(String email) {
        return !StringUtils.isBlank((CharSequence)email) && SendMailHelper.EMAIL_VALIDATION.matcher(email).matches();
    }

    protected boolean _validCaptcha(Request request, SitemapElement sitemapElement) {
        String answer;
        String captchaKey;
        return !this._pageHelper.isCaptchaRequired(sitemapElement) || CaptchaHelper.checkAndInvalidate((String)(captchaKey = request.getParameter("captcha-key")), (String)(answer = request.getParameter("captcha")));
    }

    protected Category _getCategory(String categoryID) {
        Set ids = this._categoryProviderEP.getExtensionsIds();
        for (String id : ids) {
            CategoryProvider provider = (CategoryProvider)this._categoryProviderEP.getExtension(id);
            if (!provider.hasCategory(categoryID)) continue;
            return provider.getCategory(categoryID);
        }
        return null;
    }

    protected Subscriber _createSubscritpion(String email, String siteName, String categoryID) {
        Subscriber subscriber = new Subscriber();
        subscriber.setEmail(email);
        subscriber.setSiteName(siteName);
        subscriber.setCategoryId(categoryID);
        subscriber.setSubscribedAt(new Date());
        String token = UUID.randomUUID().toString();
        subscriber.setToken(token);
        return subscriber;
    }
}

