/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.newsletter.subscribe;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.ametys.core.cocoon.ActionResultGenerator;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.plugins.newsletter.category.Category;
import org.ametys.plugins.newsletter.daos.Subscriber;
import org.ametys.plugins.newsletter.daos.SubscribersDAO;
import org.ametys.plugins.newsletter.subscribe.AbstractSubscribeAction;
import org.ametys.web.WebConstants;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.SitemapElement;
import org.ametys.web.repository.page.ZoneItem;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;

public class SubscribeAndManageAction
extends AbstractSubscribeAction
implements Initializable {
    protected UserManager _userManager;
    protected CurrentUserProvider _currentUserProvider;
    private Cache<String, String> _cache;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._userManager = (UserManager)smanager.lookup(UserManager.ROLE);
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
    }

    public void initialize() throws Exception {
        this._cache = CacheBuilder.newBuilder().expireAfterWrite(60L, TimeUnit.MINUTES).build();
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, Object> formResult = new HashMap<String, Object>();
        result.put("FormResult", formResult);
        this._addUser(result, formResult);
        ZoneItem currentZoneItem = (ZoneItem)request.getAttribute(WebConstants.REQUEST_ATTR_ZONEITEM);
        String[] categories = (String[])currentZoneItem.getServiceParameters().getValue("categories");
        this._addCategories(result, categories);
        String zoneItemId = request.getParameter("zoneitem-id");
        if (zoneItemId == null || currentZoneItem.getId().equals(zoneItemId)) {
            if (request.getParameter("back") != null) {
                this._goToStep1(request, formResult);
            } else if (request.getParameter("form-token") != null) {
                this._goToStep3(request, formResult, categories, currentZoneItem);
            } else if (request.getParameter("email") != null || request.getParameter("token") != null) {
                this._goToStep2(request, formResult, categories, currentZoneItem);
            } else {
                this._goToStep1(request, formResult);
            }
        } else {
            this._goToStep1(request, formResult);
        }
        request.setAttribute(ActionResultGenerator.MAP_REQUEST_ATTR, result);
        return EMPTY_MAP;
    }

    private Map<String, Object> _goToStep1(Request request, Map<String, Object> formResult) {
        Page page = (Page)request.getAttribute(Page.class.getName());
        formResult.put("has-captcha", this._pageHelper.isCaptchaRequired((SitemapElement)page));
        String email = request.getParameter("email");
        if (email != null) {
            formResult.put("email", request.getParameter("email"));
        }
        formResult.put("step", "1");
        return formResult;
    }

    private Map<String, Object> _goToStep2(Request request, Map<String, Object> formResult, String[] categories, ZoneItem currentZoneItem) {
        String email = null;
        String siteName = currentZoneItem.getZone().getSitemapElement().getSiteName();
        String token = request.getParameter("token");
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            Subscriber subscriber = this._subscribersDao.getSubscriberByToken(token);
            if (subscriber == null || !siteName.equals(subscriber.getSiteName())) {
                formResult.put("msg", "invalid-token");
                return this._goToStep1(request, formResult);
            }
            email = subscriber.getEmail();
        } else {
            if (!this._validCaptcha(request, currentZoneItem.getZone().getSitemapElement())) {
                formResult.put("msg", "invalid-captcha");
                return this._goToStep1(request, formResult);
            }
            formResult.put("is-from-form", "true");
            email = request.getParameter("email");
        }
        formResult.put("email", email);
        formResult.put("siteName", siteName);
        if (!this._validEmail(email)) {
            formResult.put("msg", "invalid-email");
            return this._goToStep1(request, formResult);
        }
        String finalEmail = email;
        List alreadySubscribeTo = Arrays.stream(categories).filter(categoryId -> this._subscribersDao.getSubscriber(finalEmail, siteName, (String)categoryId) != null).collect(Collectors.toList());
        formResult.put("alreadySubscribeTo", alreadySubscribeTo);
        String formToken = UUID.randomUUID().toString();
        this._cache.put((Object)formToken, (Object)email);
        formResult.put("form-token", formToken);
        formResult.put("step", "2");
        return formResult;
    }

    private Map _goToStep3(Request request, Map<String, Object> formResult, String[] categories, ZoneItem currentZoneItem) {
        String siteName = currentZoneItem.getZone().getSitemapElement().getSiteName();
        String formToken = request.getParameter("form-token");
        String email = (String)this._cache.getIfPresent((Object)formToken);
        if (!this._validEmail(email)) {
            formResult.put("msg", "token-expired");
            return this._goToStep1(request, formResult);
        }
        ArrayList<Subscriber> newSubscribers = new ArrayList<Subscriber>();
        ArrayList<String> newSubscriberTokens = new ArrayList<String>();
        ArrayList<String> removeSubscriptions = new ArrayList<String>();
        for (String categoryId : categories) {
            Subscriber subscriber = this._subscribersDao.getSubscriber(email, siteName, categoryId);
            boolean wantToSubscribe = StringUtils.equals((CharSequence)"true", (CharSequence)request.getParameter("category_" + categoryId));
            if (subscriber == null && wantToSubscribe) {
                Category category = this._getCategory(categoryId);
                if (category == null) continue;
                subscriber = this._createSubscritpion(email, siteName, categoryId);
                newSubscribers.add(subscriber);
                newSubscriberTokens.add(subscriber.getToken());
                continue;
            }
            if (subscriber == null || wantToSubscribe) continue;
            removeSubscriptions.add(subscriber.getToken());
        }
        this._subscribersDao.modifySubscriptions(newSubscribers, removeSubscriptions, SubscribersDAO.UnsubscribeOrigin.SUBSCRIBER);
        this.getLogger().info("The user with email '" + email + "' subscribed to the newsletters '" + String.join((CharSequence)",", newSubscriberTokens) + "' and unsubscribed to the newsletters '" + String.join((CharSequence)",", removeSubscriptions) + "'");
        formResult.put("step", "3");
        return formResult;
    }

    private void _addUser(Map<String, Object> result, Map<String, Object> formResult) {
        UserIdentity userIdentity = this._currentUserProvider.getUser();
        if (userIdentity != null) {
            User user = this._userManager.getUser(userIdentity);
            result.put("user", Map.of("email", user.getEmail()));
            formResult.put("email", user.getEmail());
        }
    }

    private void _addCategories(Map<String, Object> result, String[] categories) {
        List categoryObjectMap = Arrays.stream(categories).map(categoryId -> {
            Category category = this._getCategory((String)categoryId);
            HashMap<String, String> categoryMap = new HashMap<String, String>();
            categoryMap.put("id", category.getId());
            categoryMap.put("title", (String)category.getTitle());
            categoryMap.put("description", (String)category.getDescription());
            return categoryMap;
        }).collect(Collectors.toList());
        result.put("categories", categoryObjectMap);
    }
}

