<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:captcha="org.ametys.core.captcha.CaptchaHelper"
				xmlns:math="java.lang.Math"
                extension-element-prefixes="math">

	<xsl:import href="plugin:cms://stylesheets/helper/common.xsl"/>

	<xsl:param name="contextPath" select="ametys:uriPrefix()"/>
	<xsl:param name="siteName" select="ametys:site()"/>
	<xsl:param name="service-title" select="ametys:serviceParameter('header')/text()"/>
	
    <xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>
    <xsl:variable name="captchaType" select="ametys:config('runtime.captcha.type')"/>
    
	<xsl:template match="/NewsletterService">
		<html>
            <head>
                <xsl:call-template name="css"/>
            </head>
			<body>
				<div id="service-newsletter-form-{$uniqueId}" class="newsletter-subscribe">
					
					<!-- Title -->
					<xsl:choose>
						<xsl:when test="$service-title != ''">
							<h1><xsl:value-of select="$service-title"/></h1>
						</xsl:when>
						<xsl:otherwise>
							<h1><i18n:text i18n:key="NEWSLETTERS_SERVICE_SUBCRIBE_FORM_TITLE"/></h1>
						</xsl:otherwise>
					</xsl:choose>
					
					<xsl:choose>
						<xsl:when test="FormResult/msg = 'success'">
							<xsl:call-template name="success"/>
						</xsl:when>
						<xsl:when test="FormResult/msg = 'failure'">
                            <xsl:call-template name="failure"/>
                        </xsl:when>
						<xsl:otherwise>
							<!-- Form -->
							<xsl:call-template name="subscribe-form"/>
						</xsl:otherwise>
					</xsl:choose>
					
					<!-- Legal mentions -->
					<xsl:call-template name="mentions"/>
				</div>
			</body>
		</html>
	</xsl:template>
    
    <xsl:template name="css">
        <link rel="stylesheet" type="text/css" href="{ametys:pluginResourceURL('newsletter', 'css/newsletter.css')}"/>
    </xsl:template>
    
	<xsl:template name="success">
		<div class="info">
			<xsl:if test="FormResult/subscribeTo">
				<xsl:variable name="id" select="FormResult/subscribeTo"/>
				<i18n:translate>
					<i18n:text i18n:key="NEWSLETTERS_SERVICE_SUBCRIPTION_SUCCESS_SINGLE"/>
					<i18n:param><xsl:value-of select="FormResult/email"/></i18n:param>
					<i18n:param><xsl:value-of select="/*/Categories//category[@id = $id]/title"/></i18n:param>
				</i18n:translate>
			</xsl:if>
			
			<xsl:if test="FormResult/alreadySubscribeTo">
				<xsl:variable name="id" select="FormResult/alreadySubscribeTo"/>
				<i18n:translate>
					<i18n:text i18n:key="NEWSLETTERS_SERVICE_SUBCRIPTION_ALREADY_REGISTERED_SINGLE"/>
					<i18n:param><xsl:value-of select="FormResult/email"/></i18n:param>
					<i18n:param><xsl:value-of select="/*/Categories//category[@id = $id]/title"/></i18n:param>
				</i18n:translate>
			</xsl:if>
		</div>
	</xsl:template>
	
	<!-- Template to display the server error message -->
    <xsl:template name="failure">
        <div class="error">
            <p><i18n:text i18n:key="NEWSLETTERS_SERVICE_EMAIL_SERVER_ERROR"/></p>
        </div>
    </xsl:template>
	
	<!-- NOT USED.  -->
	<xsl:template name="success-multiple">
		<div class="info">
			<xsl:if test="FormResult/subscribeTo">
				<i18n:translate>
					<i18n:text i18n:key="NEWSLETTERS_SERVICE_SUBCRIPTION_SUCCESS"/>
					<i18n:param><xsl:value-of select="FormResult/email"/></i18n:param>
				</i18n:translate>
				<ul>
					<xsl:for-each select="FormResult/subscribeTo">
						<xsl:variable name="id" select="."/>
						<li><xsl:value-of select="/*/Categories//category[@id = $id]/title"/></li>
					</xsl:for-each>
				</ul>
			</xsl:if>
			
			<xsl:if test="FormResult/alreadySubscribeTo">
				<i18n:translate>
					<i18n:text i18n:key="NEWSLETTERS_SERVICE_SUBCRIPTION_ALREADY_REGISTERED"/>
					<i18n:param><xsl:value-of select="FormResult/email"/></i18n:param>
				</i18n:translate>
				<ul>
					<xsl:for-each select="FormResult/alreadySubscribeTo">
						<xsl:variable name="id" select="."/>
						<li><xsl:value-of select="/*/Categories//category[@id = $id]/title"/></li>
					</xsl:for-each>
				</ul>
			</xsl:if>
		</div>
	</xsl:template>
	
	<xsl:template name="subscribe-form">
		<form method="post">
			<p>
				<i18n:translate>
					<i18n:text i18n:key="NEWSLETTERS_SERVICE_SUBCRIBE_FORM_HINT"/>
					<i18n:param><xsl:value-of select="Categories/category/title"/></i18n:param>
				</i18n:translate>
			</p>
			<!-- email -->
			<label for="subscribe-email"><i18n:text i18n:key="NEWSLETTERS_SERVICE_INPUT_EMAIL"/></label><br/>
			<input type="text" name="email" class="text" id="subscribe-email-{$uniqueId}">
			<xsl:choose>
               <xsl:when test="FormResult/email">
                   <xsl:attribute name="value"><xsl:value-of select="FormResult/email"/></xsl:attribute>
               </xsl:when>
               <xsl:otherwise>
                   <xsl:attribute name="value"><xsl:value-of select="user/email"/></xsl:attribute>
               </xsl:otherwise>
            </xsl:choose>
				<xsl:if test="FormResult/msg = 'invalid-email'">
					<xsl:attribute name="class">invalid</xsl:attribute>
				</xsl:if>
			</input>
			<xsl:if test="FormResult/msg = 'invalid-email'">
				<div class="error"><i18n:text i18n:key="NEWSLETTERS_SERVICE_INPUT_EMAIL_INVALID"/></div>
			</xsl:if>
			<xsl:if test="FormResult/msg = 'already-exist'">
				<div class="error"><i18n:text i18n:key="NEWSLETTERS_SERVICE_EMAIL_ALREADY_EXISTS"/></div>
			</xsl:if>
			<br/><br/>
			
			<!-- category -->
			<input type="hidden" name="category" value="{Categories/category/@id}"/>
			
			<!-- page id -->
            <input type="hidden" name="page-id" value="{ametys:pageId()}"/>
            <input type="hidden" name="zoneitem-id" value="{ametys:zoneItemId()}"/>
            
            <xsl:if test="FormResult/has-captcha = 'true'">
				<xsl:if test="captcha:requiresUserInteraction()">
				    <label for="captcha"><i18n:text i18n:key="NEWSLETTERS_SERVICE_INPUT_CAPTCHA"/></label><br/>
	            </xsl:if>
				<xsl:call-template name="captcha">
					<xsl:with-param name="key-name" select="'captcha-key'"/>
		
					<xsl:with-param name="value-name" select="'captcha'"/>
					<xsl:with-param name="value-id" select="concat('captcha-', $uniqueId)"/>
					<xsl:with-param name="value-style">float: left; margin-top: <xsl:value-of select="(@height - 16) div 2"/>px; width: <xsl:value-of select="@width"/>px;</xsl:with-param>
					<xsl:with-param name="value-class">
	                    <xsl:text>captcha</xsl:text>
	    				<xsl:if test="FormResult/msg = 'invalid-captcha'">
	                        <xsl:text> invalid</xsl:text>
	    				</xsl:if>
					</xsl:with-param>
		
					<xsl:with-param name="image-alt"/>
					<xsl:with-param name="image-alt-i18n" select="false()"/>
					<xsl:with-param name="image-class">captcha-image</xsl:with-param>
					<xsl:with-param name="image-style">float:left; margin: 3px 3px 0 10px</xsl:with-param>
	                        
	                <xsl:with-param name="contextPath"><xsl:value-of select="$contextPath"/></xsl:with-param>
				</xsl:call-template>
		   </xsl:if>

			<xsl:if test="FormResult/msg = 'invalid-captcha'">
				<div class="error"><i18n:text i18n:key="NEWSLETTERS_SERVICE_INPUT_CAPTCHA_INVALID"/></div>
			</xsl:if>
			<br class="break"/>
			
			<input type="hidden" name="subscribe"/>
			<input type="hidden" name="siteName" value="{$siteName}"/>
			<input type="submit" class="submit" value="NEWSLETTERS_SERVICE_INPUT_SUBMIT" i18n:attr="value"/>
		</form>
	</xsl:template>
	
	<!-- NOT USED. Handle multi-categories -->
	<xsl:template name="categories">
		<xsl:choose>
			<xsl:when test="count(Categories//category) &gt; 1">
				<p><i18n:text i18n:key="NEWSLETTERS_SERVICE_SELECT_CATEGORY"/></p>
				
				<xsl:apply-templates select="Categories/category"/>
			</xsl:when>
			<xsl:otherwise>
				<input type="hidden" name="category" value="{Categories/category/@id}"/>
			</xsl:otherwise>
		</xsl:choose>
		
		<xsl:if test="FormResult/msg = 'invalid-category'">
			<div class="error">
                <xsl:choose>
                     <xsl:when test="captcha:requiresUserInteraction()">
                         <i18n:text i18n:key="NEWSLETTERS_SERVICE_INPUT_CAPTCHA_INVALID" i18n:catalogue="plugin.newsletter"/>
                     </xsl:when>
                     <xsl:otherwise>
                        <i18n:text i18n:key="NEWSLETTERS_SERVICE_INPUT_RECAPTCHA_INVALID" i18n:catalogue="plugin.newsletter"/>
                     </xsl:otherwise>
                 </xsl:choose>
           </div>      
		</xsl:if>
			
		<br/><br/>
	</xsl:template>
	
	<xsl:template match="category">
		<xsl:param name="indent">0</xsl:param>
		
		<xsl:variable name="id" select="@id"/>
		<input type="checkbox" name="category" value="{@id}" id="category_{$uniqueId}_{position()}" style="margin-left: {$indent}px">
			<xsl:if test="/NewsletterService/FormResult/category[. = $id]">
				<xsl:attribute name="checked">checked</xsl:attribute>
			</xsl:if>
		</input>
		<label for="category_{$uniqueId}_{position()}"><xsl:value-of select="title"/></label>
		<xsl:if test="description != ''">
			<span class="description">(<xsl:value-of select="description"/>)</span>
		</xsl:if>
		<br/>
		
		<xsl:apply-templates select="category">
			<xsl:with-param name="indent" select="$indent + 20"/>
		</xsl:apply-templates>
		
	</xsl:template>
	
	<xsl:template name="mentions">
		<div class="mentions">
			<i18n:text i18n:key="NEWSLETTERS_SERVICE_LEGAL_MENTIONS"/>
		</div>
	</xsl:template>

</xsl:stylesheet>
