<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:math="java.lang.Math"
                xmlns:captcha="org.ametys.core.captcha.CaptchaHelper"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                extension-element-prefixes="math ametys">

    <xsl:import href="service:web://pages/services/common.xsl"/>    

    <xsl:param name="service-title" select="string(ametys:serviceParameter('header')/text())"/>
    
    <xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>
    <xsl:variable name="captchaType" select="ametys:config('runtime.captcha.type')"/>
    
    <!-- Used in common.xsl -->
    <xsl:variable name="common-service-css-class-name">newsletter newsletter-subscribe-and-manage</xsl:variable>
    <xsl:variable name="is-empty" select="false()"/>
    <xsl:variable name="common-service-name">service-newsletter-subscribe-and-manage</xsl:variable>  
    <xsl:variable name="rendering-context" select="ametys:renderingContext()"/>        
    
    <xsl:template name="css">
        <link rel="stylesheet" type="text/css" href="{ametys:pluginResourceURL('newsletter', 'css/newsletter.css')}"/>
    </xsl:template>
    
    <!-- +
         | BODY
         + -->    

    <!-- Used in common.xsl -->
    <xsl:template name="common-service-body-nonempty-content-title">
        <xsl:call-template name="common-service-body-nonempty-content-title-content">
            <xsl:with-param name="title" select="$service-title"/>  
            <xsl:with-param name="default-title"><i18n:text i18n:key="NEWSLETTERS_SERVICE_SUBSCRIBE_NEWSLETTER_FORM_TITLE" i18n:catalogue="plugin.newsletter"/></xsl:with-param>                           
        </xsl:call-template>
    </xsl:template>

    <!-- Used in common.xsl --> 
    <xsl:template name="common-service-body-nonempty-content-content">
        <xsl:call-template name="subscribe-steps"/>
    </xsl:template>    
    
    <!-- Template used by subscribe form -->
    <xsl:template name="subscribe-steps">
        <div data-ametys-newsletter-step="{/ActionResult/FormResult/step}">
            <xsl:choose>
                <xsl:when test="/ActionResult/FormResult/step = 3">
                    <xsl:call-template name="step3"/>
                </xsl:when>
                <xsl:when test="/ActionResult/FormResult/step = 2">
                    <xsl:call-template name="step2"/>
                </xsl:when>
                <xsl:otherwise>
                    <!-- Form -->
                    <xsl:call-template name="step1"/>
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>
    
    <!-- Template used for the first step of subscribe form -->
    <xsl:template name="step1">
        <xsl:call-template name="step1-top-text"/>
        
        <xsl:call-template name="errors-message"/>
        
        <form action="{resolver:resolve('page', ametys:pageId())}" method="post">
            <xsl:if test="$rendering-context = 'back'">
                <xsl:attribute name="onsubmit"> return alertNotAvailable();</xsl:attribute>
		        <script>
		            function alertNotAvailable()
		            {
		                parent.Ext.Msg.alert("<i18n:text i18n:key='PLUGINS_FORMS_FORMS_VALIDATE_DISABLED_BACK_TITLE' i18n:catalogue='plugin.forms'/>",
		                                       "<i18n:text i18n:key='PLUGINS_FORMS_FORMS_VALIDATE_DISABLED_BACK_MESSAGE' i18n:catalogue='plugin.forms'/>");
		                return false;
		            }
		        </script>
            </xsl:if>
        
            <div>
                <input type="hidden" name="zoneitem-id" value="{ametys:zoneItemId()}"/>
                
                <!-- email -->
                <xsl:call-template name="email-input"/>
                
                <!-- captcha -->
                <xsl:if test="/ActionResult/FormResult/has-captcha = 'true'">
                    <xsl:call-template name="captcha-input"/>
                </xsl:if>
        
                <xsl:call-template name="step1-bottom-text"/>
                
                <xsl:call-template name="step1-buttons"/>
        
                <xsl:call-template name="step1-mentions"/>
            </div>
        </form>
    </xsl:template>
    
    <!-- Template used for the email input -->
    <xsl:template name="email-input">
        <div class="field">
            <div class="label">
                <label for="subscribe-email-{$uniqueId}">
                    <i18n:text i18n:key="NEWSLETTERS_SERVICE_INPUT_EMAIL_LABEL"/>
                    <span class="mandatory-marker"><i18n:text i18n:key="PLUGINS_WEB_FRONTOFICE_MANDATORY_FIELD" i18n:catalogue="plugin.web"/></span>
                </label>          
            </div>
            <div>
                <xsl:attribute name="class">
                    <xsl:text>input</xsl:text>
                    <xsl:if test="/ActionResult/FormResult/msg = 'invalid-email'">
                        <xsl:text> invalid</xsl:text>
                    </xsl:if>
                </xsl:attribute>
                
                <input type="text" name="email" class="text" id="subscribe-email-{$uniqueId}" value="{/ActionResult/FormResult/email}"/>
            </div>
            <div class="field-end"></div>
        </div>
    </xsl:template>
    
    <!-- Template used for the captcha input -->
    <xsl:template name="captcha-input">
        <div class="field">
            <xsl:if test="captcha:requiresUserInteraction()">
                <div class="label">
                    <label for="captcha-{$uniqueId}">
                        <i18n:text i18n:key="NEWSLETTERS_SERVICE_INPUT_CAPTCHA_LABEL"/>
                        <span class="mandatory-marker"><i18n:text i18n:key="PLUGINS_WEB_FRONTOFICE_MANDATORY_FIELD" i18n:catalogue="plugin.web"/></span>      
                    </label>
                </div>
            </xsl:if>
            <div class="input">
                <xsl:if test="FormResult/msg = 'invalid'">
                    <xsl:attribute name="class">invalid</xsl:attribute>
                </xsl:if>
        
                <xsl:call-template name="captcha">
                    <xsl:with-param name="key-name" select="'captcha-key'"/>
        
                    <xsl:with-param name="value-name" select="'captcha'"/>
                    <xsl:with-param name="value-id" select="concat('captcha-', $uniqueId)"/>
                    <xsl:with-param name="value-class">captcha</xsl:with-param>
        
                    <xsl:with-param name="image-alt"/>
                    <xsl:with-param name="image-alt-i18n" select="false()"/>
                    <xsl:with-param name="image-class">captcha-image</xsl:with-param>
                    
                    <xsl:with-param name="contextPath"><xsl:value-of select="$uri-prefix"/></xsl:with-param>
                </xsl:call-template>                
            </div>
            <div class="field-end"></div>
        </div>
    </xsl:template>
    
    <!-- Template used for the second step of subscribe form -->
    <xsl:template name="step2">
        <xsl:call-template name="step2-top-text"/>
        
        <xsl:call-template name="errors-message"/>
        
        <form action="" method="post">
            <div>
                <input type="hidden" name="zoneitem-id" value="{ametys:zoneItemId()}"/>
                <input type="hidden" name="form-token" value="{/ActionResult/FormResult/form-token}"/>
                
                <xsl:call-template name="display-email"/>
                
                <xsl:call-template name="categories"/>
                
                <xsl:call-template name="step2-bottom-text"/>
        
                <xsl:call-template name="step2-buttons"/>
        
                <xsl:call-template name="step2-mentions"/>
            </div>
        </form>
    </xsl:template>
    
    <!-- Template used for the third and final step of subscribe form -->
    <xsl:template name="step3">
        <xsl:call-template name="step3-top-text"/>
        
        <xsl:call-template name="step3-bottom-text"/>
        
        <xsl:call-template name="step3-buttons"/>
        
        <xsl:call-template name="step3-mentions"/>
    </xsl:template>
    
    <!-- Template used to display the introductory text to subscribe in step 1  -->
    <xsl:template name="step1-top-text">    
        <h2 class="ametys-service-title-2"><i18n:text i18n:key="NEWSLETTERS_SERVICE_SUBSCRIBE_NEWSLETTER_FORM_SUBTITLE_STEP1"/></h2>
        <p><i18n:text i18n:key="NEWSLETTERS_SERVICE_SUBSCRIBE_NEWSLETTER_FORM_HINT_STEP1"/></p>
        <p class="mandatory-hint">
            <i18n:text i18n:key="PLUGINS_WEB_FRONTOFICE_MANDATORY_LABEL" i18n:catalogue="plugin.web"/>
        </p>
    </xsl:template>
    
    <!-- Template used to display the bottom text to subscribe in step 1  -->
    <xsl:template name="step1-bottom-text">    
    </xsl:template>
    
    <!-- Template used to display the buttons to subscribe in step 1  -->
    <xsl:template name="step1-buttons">    
        <xsl:call-template name="submit-button"/>
    </xsl:template>
    
    <!-- Template used to display legal mentions in step 1  -->
    <xsl:template name="step1-mentions">    
        <xsl:call-template name="mentions"/>
    </xsl:template>
    
    <!-- Template used to display the introductory text to subscribe in step 2  -->
    <xsl:template name="step2-top-text">    
        <h2 class="ametys-service-title-2"><i18n:text i18n:key="NEWSLETTERS_SERVICE_SUBSCRIBE_NEWSLETTER_FORM_SUBTITLE_STEP2"/></h2>
    </xsl:template>
    
    <!-- Template used to display the bottom text to subscribe in step 2  -->
    <xsl:template name="step2-bottom-text">    
        <xsl:if test="/ActionResult/FormResult/alreadySubscribeTo">
            <p><i18n:text i18n:key="NEWSLETTERS_SERVICE_SUBSCRIBE_NEWSLETTER_FORM_HINT_STEP2"/></p>
        </xsl:if>       
    </xsl:template>
    
    <!-- Template used to display the buttons to subscribe in step 2  -->
    <xsl:template name="step2-buttons">
        <!-- Display only if we come from step 1 -->
        <xsl:if test="/ActionResult/FormResult/is-from-form = 'true'">
            <xsl:call-template name="back-button"/>
        </xsl:if>
        <xsl:call-template name="submit-button"/>
    </xsl:template>
    
    <!-- Template used to display legal mentions in step 2  -->
    <xsl:template name="step2-mentions">    
        <xsl:call-template name="mentions"/>
    </xsl:template>
    
    <!-- Template used to display the introductory text to subscribe in step 3  -->
    <xsl:template name="step3-top-text">    
        <h2 class="ametys-service-title-2"><i18n:text i18n:key="NEWSLETTERS_SERVICE_SUBSCRIBE_NEWSLETTER_FORM_SUBTITLE_STEP3"/></h2>
    </xsl:template>
    
    <!-- Template used to display the bottom text to subscribe in step 3  -->
    <xsl:template name="step3-bottom-text">    
        <div class="info">
            <p><i18n:text i18n:key="NEWSLETTERS_SERVICE_SUBSCRIBE_NEWSLETTER_FORM_HINT_STEP3"/></p>
        </div>   
    </xsl:template>
    
    <!-- Template used to display the buttons to subscribe in step 3  -->
    <xsl:template name="step3-buttons">
    </xsl:template>
    
    <!-- Template used to display legal mentions in step 3  -->
    <xsl:template name="step3-mentions">    
        <xsl:call-template name="mentions"/>
    </xsl:template>
    
    <!-- Template for submit button -->
    <xsl:template name="submit-button">    
	    <xsl:call-template name="common-utils-input-submit">
            <xsl:with-param name="i18nkey" select="'plugin.newsletter:NEWSLETTERS_SERVICE_INPUT_SUBMIT'" />
	    </xsl:call-template>
    </xsl:template>
    
    <!-- Template used to display back button -->
    <xsl:template name="back-button">
        <!-- back button -->
        <xsl:call-template name="common-utils-input-submit">
            <xsl:with-param name="name">back</xsl:with-param>
            <xsl:with-param name="i18nkey" select="'plugin.newsletter:NEWSLETTERS_SERVICE_SUBSCRIBE_NEWSLETTER_BACK'" />                
        </xsl:call-template>
    </xsl:template>
    
    <!-- Template used to display email during the second step -->
    <xsl:template name="display-email">
        <p class="subscription-email"><i18n:text i18n:key="NEWSLETTERS_SERVICE_SUBSCRIBE_NEWSLETTER_EMAIL_PREFIX"/><xsl:value-of select="/ActionResult/FormResult/email"/></p>
    </xsl:template>
    
    <!-- Template used to display categories of newsletters as checkboxes -->
    <xsl:template name="categories">
        <ul>
            <xsl:for-each select="/ActionResult/categories/categories">
                <xsl:call-template name="category">
                    <xsl:with-param name="id"><xsl:value-of select="id"/></xsl:with-param>
                </xsl:call-template>
            </xsl:for-each>
        </ul>
    </xsl:template>
    
    <!-- Template used to display category of newsletters as a checkbox -->
    <xsl:template name="category">
        <xsl:param name="id"/>
        <li>
            <div class="field checkbox category-checkbox">
                <div class="input">
                    <input type="checkbox" name="category_{$id}" value="true" id="category-{$uniqueId}-{$id}">
                        <xsl:if test="/ActionResult/FormResult/alreadySubscribeTo/alreadySubscribeTo[. = $id]">
                            <xsl:attribute name="checked">checked</xsl:attribute>
                        </xsl:if>
                    </input>            
                </div>
                <div class="label">
                    <label for="category-{$uniqueId}-{$id}"><xsl:value-of select="title"/></label>
                    <xsl:if test="description != ''">
                        <span class="description">(<xsl:value-of select="description"/>)</span>
                    </xsl:if>            
                </div>     
                <div class="field-end"></div>       
            </div>
        </li>
    </xsl:template>
    
    <xsl:template name="errors-message">
        <xsl:variable name="error-invalid-email" select="/ActionResult/FormResult/msg = 'invalid-email'"/>
        <xsl:variable name="error-token-expired" select="/ActionResult/FormResult/msg = 'token-expired'"/>
        <xsl:variable name="error-invalid-captcha" select="/ActionResult/FormResult/msg = 'invalid-captcha'"/>
        <xsl:variable name="error-invalid-token" select="/ActionResult/FormResult/msg = 'invalid-token'"/>

        <xsl:if test="$error-invalid-email or $error-invalid-captcha or $error-invalid-token or $error-token-expired">
            <div class="error">
            
	            <xsl:if test="$error-invalid-email or $error-invalid-captcha">
	                <p><i18n:text i18n:key="NEWSLETTERS_SERVICE_INPUT_ERRORS" i18n:catalogue="plugin.newsletter"/></p>
	            </xsl:if>
	            <ul>
                    <xsl:if test="$error-invalid-email">
                        <xsl:call-template name="error-message">
                              <xsl:with-param name="i18nkey"><i18n:text i18n:key="NEWSLETTERS_SERVICE_INPUT_EMAIL_INVALID" i18n:catalogue="plugin.newsletter"/></xsl:with-param>
                        </xsl:call-template>
                    </xsl:if>
                    <xsl:if test="$error-invalid-captcha">
                        <xsl:choose>
                            <xsl:when test="captcha:requiresUserInteraction()">
                                <xsl:call-template name="error-message">
                                    <xsl:with-param name="i18nkey"><i18n:text i18n:key="NEWSLETTERS_SERVICE_INPUT_CAPTCHA_INVALID" i18n:catalogue="plugin.newsletter"/></xsl:with-param>                
                                </xsl:call-template>  
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:call-template name="error-message">
                                    <xsl:with-param name="i18nkey"><i18n:text i18n:key="NEWSLETTERS_SERVICE_INPUT_RECAPTCHA_INVALID" i18n:catalogue="plugin.newsletter"/></xsl:with-param>                
                                </xsl:call-template>  
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:if>
                    
			        <xsl:if test="$error-invalid-token">
	                    <xsl:call-template name="error-message">
	                          <xsl:with-param name="i18nkey"><i18n:text i18n:key="NEWSLETTERS_SERVICE_INPUT_TOKEN_INVALID" i18n:catalogue="plugin.newsletter"/></xsl:with-param>
	                    </xsl:call-template>
			        </xsl:if>
			        <xsl:if test="$error-token-expired">
	                    <xsl:call-template name="error-message">
	                          <xsl:with-param name="i18nkey"><i18n:text i18n:key="NEWSLETTERS_SERVICE_INPUT_TOKEN_EXPIRED" i18n:catalogue="plugin.newsletter"/></xsl:with-param>
	                    </xsl:call-template>
			        </xsl:if>
                </ul>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="error-message">
        <xsl:param name="i18nkey" />
        <li>
            <xsl:copy-of select="$i18nkey"/>
        </li>
    </xsl:template>
    
    
    <!-- Template used to display mentions -->
    <xsl:template name="mentions">
        <div class="mentions">
            <i18n:text i18n:key="NEWSLETTERS_SERVICE_LEGAL_MENTIONS"/>
        </div>
    </xsl:template>
</xsl:stylesheet>
