/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
 
 /**
  * This class is the representation of a newsletter category.
  */
 Ext.define('Ametys.cms.newsletter.NewsletterCategory', {
 	config: {
 		/**
 		 * @cfg {String} id The unique id of the category
 		 */
 		/**
 		 * @method getId Gets the #cfg-id
 		 * @return {String} The id
 		 */
 		/** @ignore */
 		id: null,
 		/**
 		 * @cfg {String} parentId The id of the parent category
 		 */
 		/**
 		 * @method getParentId Gets the #cfg-parentId
 		 * @return {String} The parent id
 		 */
 		/** @ignore */
 		parentId: null,
 		/**
 		 * @cfg {String} title The title of the category
 		 */
 		/**
 		 * @method getTitle Gets the #cfg-title
 		 * @return {String} The title
 		 */
 		/** @ignore */
 		title: null,
 		/**
 		 * @cfg {String} description The description of the category
 		 */
 		/**
 		 * @method getDescription Gets the #cfg-description
 		 * @return {String} The description
 		 */
 		/** @ignore */
 		description: null,
 		/**
 		 * @cfg {String} name The name of the category
 		 */
 		/**
 		 * @method getName Gets the #cfg-name
 		 * @return {String} The name
 		 */
 		/** @ignore */
 		name: null,
 		/**
 		 * @cfg {String} template The template of the category
 		 */
 		/**
 		 * @method getTemplate Gets the #cfg-template
 		 * @return {String} The template
 		 */
 		/** @ignore */
 		template: null,
 		/**
 		 * @cfg {String} mode The mode of the category. Can be "read" or "write"
 		 */
 		/**
 		 * @method getMode Gets the #cfg-mode
 		 * @return {String} The mode
 		 */
 		/** @ignore */
 		mode: null,
 		/**
 		 * @cfg {String} lang The lang of the category
 		 */
 		/**
 		 * @method getLang Gets the #cfg-lang
 		 * @return {String} The lang
 		 */
 		/** @ignore */
 		lang: null,
 		/**
 		 * @cfg {String} siteName The site name
 		 */
 		/**
 		 * @method getSiteName Gets the #cfg-siteName
 		 * @return {String} The site name
 		 */
 		/** @ignore */
 		siteName: null,
 		
 		/**
 		 * @cfg {String} automaticIds The ids of automatic newsletters
 		 */
 		/**
 		 * @method getAutomaticIds Gets the #cfg-automaticIds
 		 * @return {String} The ids of automatic newsletters
 		 */
 		/** @ignore */
 		automaticIds: []
 	},
 	
 	/**
 	 * Creates a category instance
 	 * @param {Object} config See configuration doc.
 	 */
 	constructor: function(config)
 	{
 		this.initConfig(config);
 		
 		this._messageTarget = config.messageTarget || Ametys.message.MessageTarget.NEWSLETTER_CATEGORY;
 	},
 	
 	/**
 	 * Gets the category's properties
 	 * @param {Object} initialProperty The initial property
 	 * @return {Object} The category's properties
 	 */
 	getProperties: function(initialProperty)
 	{
 		return Ext.apply({
 			id: this._id,
 			parentId: this._parentId,
 			title: this._title,
 			name: this._name,
 			template: this._template,
 			mode: this._mode,
 			lang: this._lang,
 			siteName: this._siteName
 		}, initialProperty);
 	}
 	
 });