/*
 *  Copyright 2012 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.newsletter.auto;

import java.util.Collection;
import java.util.Map;

import org.ametys.runtime.i18n.I18nizableText;

/**
 * Interface defining an automatic newsletter service.
 */
public interface AutomaticNewsletter
{
    
    /**
     * The frequency type.
     */
    public enum FrequencyType
    {
        /** Week frequency. */
        WEEK,
        /** Month frequency. */
        MONTH
    }
    
    /**
     * Get the automatic newsletter label.
     * @return the automatic newsletter label.
     */
    public I18nizableText getLabel();
    
    /**
     * Get the automatic newsletter description.
     * @return the automatic newsletter description.
     */
    public I18nizableText getDescription();
    
    /**
     * Get the automatic newsletter title.
     * @return the automatic newsletter title.
     */
    public I18nizableText getNewsletterTitle();
    
    /**
     * Get the automatic newsletter frequency type.
     * @return the automatic newsletter frequency type.
     */
    public FrequencyType getFrequencyType();
    
    /**
     * Get the automatic newsletter frequency identifiers.
     * @return the automatic newsletter frequency identifiers.
     */
    public Collection<Integer> getDayNumbers();
    
    /**
     * Get the filters which this automatic newsletter bases on.
     * @return a Map of filter name -&gt; filter ID.
     */
    public Map<String, String> getFilters();
    
}
