/*
 *  Copyright 2012 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.newsletter.auto;

import java.util.List;

/**
 * A content filter result.
 */
public class AutomaticNewsletterFilterResult
{
    
    /** A list of content id returned by the filter. */
    protected List<String> _contentIds;
    
    /** The filter metadata set name. */
    protected String _viewName;
    
    /**
     * Get the contentIds.
     * @return the contentIds
     */
    public List<String> getContentIds()
    {
        return _contentIds;
    }
    
    /**
     * Set the contentIds.
     * @param contentIds the contentIds to set
     */
    public void setContentIds(List<String> contentIds)
    {
        this._contentIds = contentIds;
    }
    
    /**
     * Get the viewName.
     * @return the viewName
     */
    public String getViewName()
    {
        return _viewName;
    }
    
    /**
     * Set the viewName.
     * @param viewName the viewName to set
     */
    public void setViewName(String viewName)
    {
        this._viewName = viewName;
    }
    
    /**
     * Test if the filter has results.
     * @return true if the filter has results, false otherwise.
     */
    public boolean hasResults()
    {
        return !_contentIds.isEmpty();
    }
    
}
