/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.newsletter.daos;

import java.util.Date;


/**
 * This class represents a newsletter's subscriber
 */
public class Subscriber
{
    private String _categoryId;
    private String _siteName;
    private String _email;
    private Date _subscribedAt;
    private String _token;
    
    /**
     * Returns the newsletter category
     * @return the newsletter category
     */
    public String getCategoryId ()
    {
        return _categoryId;
    }
    
    /**
     * Returns the newsletter site name
     * @return the newsletter site name
     */
    public String getSiteName ()
    {
        return _siteName;
    }
    
    /**
     * Get the subscriber email
     * @return the subscriber email
     */
    public String getEmail ()
    {
        return _email;
    }
    
    /**
     * Returns the date of subscription
     * @return the date of subscription
     */
    public Date getSubscribedAt ()
    {
        return _subscribedAt;
    }
    
    /**
     * Set the subscriber email
     * @param email The email to set
     */
    public void setEmail (String email)
    {
        _email = email;
    }
    
    /**
     * Set the site name
     * @param siteName The site name to set
     */
    public void setSiteName (String siteName)
    {
        _siteName = siteName;
    }
    
    /**
     * The id of the category
     * @param categoryId The category's id
     */
    public void setCategoryId (String categoryId)
    {
        _categoryId = categoryId;
    }
    
    /**
     * Set the date of subscription
     * @param subscribedAt The date of subscription
     */
    public void setSubscribedAt (Date subscribedAt)
    {
        _subscribedAt = subscribedAt;
    }
    
    /**
     * Get the user token
     * @return the user token
     */
    public String getToken ()
    {
        return _token;
    }
    
    /**
     * Set the user token
     * @param token the user token
     */
    public void setToken (String token)
    {
        _token = token;
    }
}
