/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.newsletter.subscribe;

import java.io.IOException;
import java.util.List;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.SAXException;

import org.ametys.core.util.DateUtils;
import org.ametys.plugins.newsletter.daos.Subscriber;
import org.ametys.plugins.newsletter.daos.SubscribersDAO;

/**
 * Generates SAX events for subscribers 
 */
public class SubscribersGenerator extends ServiceableGenerator
{
    private SubscribersDAO _subscribersDao;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _subscribersDao = (SubscribersDAO) smanager.lookup(SubscribersDAO.ROLE);
    }
    
    @Override
    public void generate() throws IOException, SAXException, ProcessingException
    {
        Request request = ObjectModelHelper.getRequest(objectModel);

        String siteName = request.getParameter("siteName");
        String categoryId = request.getParameter("categoryID");

        contentHandler.startDocument();
        XMLUtils.startElement(contentHandler, "subscribers");
        
        List<Subscriber> subscribers;
        if (siteName != null && categoryId != null)
        {
            subscribers = _subscribersDao.getSubscribers(siteName, categoryId);
        }
        else
        {
            subscribers = _subscribersDao.getSubscribers();
        }
        
        for (Subscriber subscriber : subscribers)
        {
            XMLUtils.startElement(contentHandler, "subscriber");
            
            XMLUtils.createElement(contentHandler, "email", subscriber.getEmail());
            XMLUtils.createElement(contentHandler, "siteName", subscriber.getSiteName());
            XMLUtils.createElement(contentHandler, "category", subscriber.getCategoryId());
            XMLUtils.createElement(contentHandler, "subscribedAt", DateUtils.dateToString(subscriber.getSubscribedAt()));
            
            XMLUtils.endElement(contentHandler, "subscriber");
        }
        
        XMLUtils.endElement(contentHandler, "subscribers");
        contentHandler.endDocument();
    }

}
