/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.odf.ose.db;

import java.util.ArrayList;
import java.util.List;
import org.ametys.odf.ose.db.parameter.ValuedQueryParameter;

public class ParameterizableQuery {
    private String _query;
    private List<ValuedQueryParameter> _parameters;

    public ParameterizableQuery(String query, List<ValuedQueryParameter> parameters) {
        this._query = query;
        this._parameters = parameters;
    }

    public ParameterizableQuery(String query) {
        this(query, new ArrayList<ValuedQueryParameter>());
    }

    public String getQuery() {
        return this._query;
    }

    public List<ValuedQueryParameter> getParameters() {
        return this._parameters;
    }

    public String toReadableString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SQL query:");
        sb.append(System.lineSeparator());
        sb.append(this.getQuery());
        sb.append(System.lineSeparator());
        sb.append("Parameters:");
        for (ValuedQueryParameter param : this.getParameters()) {
            sb.append(System.lineSeparator());
            sb.append(" - ");
            sb.append(param.getName());
            sb.append(" = ");
            sb.append(param.getValue());
        }
        return sb.toString();
    }
}

