/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.odf.ose.export;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.odf.ose.db.ParameterizableQuery;
import org.ametys.odf.ose.db.column.Column;
import org.ametys.odf.ose.db.parameter.QueryParameter;
import org.ametys.odf.ose.db.parameter.ValuedQueryParameter;
import org.apache.commons.lang3.StringUtils;

public final class ExportUtils {
    private static final String __TABLE_PREFIX = "AMETYS_";
    private static final String __VIEW_PREFIX = "SRC_";

    private ExportUtils() {
    }

    public static ParameterizableQuery insertIntoAmetys(String baseName, List<QueryParameter> parameters) {
        return ExportUtils.insertInto(__TABLE_PREFIX + baseName, parameters);
    }

    public static ParameterizableQuery insertInto(String tableName, List<QueryParameter> parameters) {
        StringBuilder sb = new StringBuilder("INSERT INTO ");
        sb.append(tableName);
        sb.append(" (");
        sb.append(((Stream)parameters.stream().sequential()).map(QueryParameter::getName).collect(Collectors.joining(", ")));
        sb.append(") VALUES (");
        sb.append(((Stream)parameters.stream().sequential()).map(QueryParameter::getParameter).collect(Collectors.joining(", ")));
        sb.append(")");
        return new ParameterizableQuery(sb.toString(), ((Stream)parameters.stream().sequential()).filter(ValuedQueryParameter.class::isInstance).map(ValuedQueryParameter.class::cast).collect(Collectors.toList()));
    }

    public static ParameterizableQuery deleteFromAmetys(String baseName) {
        return ExportUtils.deleteFrom(__TABLE_PREFIX + baseName);
    }

    public static ParameterizableQuery deleteFrom(String tableName) {
        StringBuilder sb = new StringBuilder("DELETE FROM ");
        sb.append(tableName);
        return new ParameterizableQuery(sb.toString());
    }

    public static List<ParameterizableQuery> initializeTableAndView(String baseName, Set<Column> tableColumns) {
        ArrayList<ParameterizableQuery> queries = new ArrayList<ParameterizableQuery>();
        queries.add(ExportUtils._dropView(baseName));
        queries.add(ExportUtils._dropTable(baseName));
        queries.add(ExportUtils._createTable(baseName, tableColumns));
        queries.add(ExportUtils._createView(baseName, tableColumns));
        queries.add(ExportUtils._activateImport(baseName));
        return queries;
    }

    private static ParameterizableQuery _dropTable(String baseName) {
        StringBuilder sb = new StringBuilder("DROP TABLE ");
        sb.append(__TABLE_PREFIX);
        sb.append(baseName);
        return new ParameterizableQuery(sb.toString());
    }

    private static ParameterizableQuery _dropView(String baseName) {
        StringBuilder sb = new StringBuilder("DROP VIEW ");
        sb.append(__VIEW_PREFIX);
        sb.append(baseName);
        return new ParameterizableQuery(sb.toString());
    }

    private static ParameterizableQuery _createTable(String baseName, Set<Column> tableColumns) {
        StringBuilder sb = new StringBuilder("CREATE TABLE ");
        sb.append(__TABLE_PREFIX);
        sb.append(baseName);
        sb.append(" (");
        sb.append(tableColumns.stream().map(column -> column.getColumnDescription()).filter(StringUtils::isNotEmpty).collect(Collectors.joining(", ")));
        sb.append(")");
        return new ParameterizableQuery(sb.toString());
    }

    private static ParameterizableQuery _createView(String baseName, Set<Column> tableColumns) {
        StringBuilder sb = new StringBuilder("CREATE VIEW ");
        sb.append(__VIEW_PREFIX);
        sb.append(baseName);
        sb.append(" AS SELECT ");
        sb.append(tableColumns.stream().map(column -> column.getViewDescription()).filter(StringUtils::isNotEmpty).collect(Collectors.joining(", ")));
        sb.append(" FROM ");
        sb.append(__TABLE_PREFIX);
        sb.append(baseName);
        sb.append(" TBL");
        return new ParameterizableQuery(sb.toString(), tableColumns.stream().map(Column::getViewParameters).flatMap(Collection::stream).collect(Collectors.toList()));
    }

    private static ParameterizableQuery _activateImport(String baseName) {
        StringBuilder sb = new StringBuilder("UPDATE IMPORT_TABLES SET SYNC_ENABLED = 1, SYNC_JOB = 'synchro-ametys', SYNC_FILTRE = NULL WHERE TABLE_NAME = '");
        sb.append(baseName);
        sb.append("'");
        return new ParameterizableQuery(sb.toString());
    }
}

