/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.clientsideelement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.ametys.cms.model.restrictions.RestrictedModelItem;
import org.ametys.cms.repository.Content;
import org.ametys.core.ui.Callable;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.clientsideelement.DeleteContentClientSideElement;
import org.ametys.plugins.odfpilotage.helper.PilotageClientSideElementHelper;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ModelHelper;
import org.ametys.runtime.model.ModelItem;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class DeleteODFPilotageContentClientSideElement
extends DeleteContentClientSideElement {
    protected PilotageClientSideElementHelper _pilotageClientSideHelper;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._pilotageClientSideHelper = (PilotageClientSideElementHelper)((Object)smanager.lookup(PilotageClientSideElementHelper.ROLE));
    }

    @Callable(rights={""})
    public Map<String, Object> getStatus(List<String> contentIds) {
        Map results = super.getStatus(contentIds);
        ArrayList<Map> invalidContents = new ArrayList<Map>();
        List allrightContents = (List)results.get("allright-contents");
        block0: for (Map allRightContent : allrightContents) {
            String contentId = (String)allRightContent.get("id");
            Content content = (Content)this._resolver.resolveById(contentId);
            if (!(content instanceof ProgramItem)) continue;
            ProgramItem programItem = (ProgramItem)content;
            List parentProgramItems = this._odfHelper.getParentProgramItems(programItem);
            for (ProgramItem parentProgramItem : parentProgramItems) {
                RestrictedModelItem rModelItem;
                ModelItem modelItem;
                String parentAttributeName = this._odfHelper.getDescendantRelationAttributeName(parentProgramItem, programItem);
                if (parentAttributeName == null || !((modelItem = ModelHelper.getModelItem((String)parentAttributeName, (Collection)((Content)parentProgramItem).getModel())) instanceof RestrictedModelItem) || (rModelItem = (RestrictedModelItem)modelItem).canWrite((Object)parentProgramItem)) continue;
                Map contentParams = this.getContentDefaultParameters(content);
                contentParams.put("description", this._getInvalidRestrictionStatusDescription(content));
                invalidContents.add(contentParams);
                continue block0;
            }
        }
        List<Object> invalidContentIds = invalidContents.stream().map(p -> p.get("id")).toList();
        results.put("allright-contents", allrightContents.stream().filter(p -> !invalidContentIds.contains(p.get("id"))).toList());
        results.put("invalidrestrictionstatus-contents", invalidContents);
        return results;
    }

    protected I18nizableText _getInvalidRestrictionStatusDescription(Content content) {
        ArrayList<String> workflowI18nParameters = new ArrayList<String>();
        workflowI18nParameters.add(this._contentHelper.getTitle(content));
        I18nizableText ed = (I18nizableText)this._script.getParameters().get("invalidrestrictionstatus-content-description");
        return new I18nizableText(ed.getCatalogue(), ed.getKey(), workflowI18nParameters);
    }
}

