/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.cost.entity;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class Effectives {
    private Optional<Double> _overriddenEffective = Optional.empty();
    private Optional<Double> _enteredEffective = Optional.empty();
    private Optional<Double> _estimatedEffective = Optional.empty();
    private Map<String, Double> _estimatedEffectiveByPath = new HashMap<String, Double>();
    private Optional<Double> _computedEffective = Optional.empty();
    private Map<String, Double> _computedEffectiveByStep = new HashMap<String, Double>();
    private Map<String, Double> _localEffectiveByPath = new HashMap<String, Double>();
    private Integer _nbOccurrences = 1;
    private boolean _isInconsistentWithParent = false;

    public Effectives cloneWithWeight(double weight) {
        Effectives clone = new Effectives();
        clone.setOverriddenEffective(this._overriddenEffective.map(eff -> eff * weight));
        clone.setEnteredEffective(this._enteredEffective.map(eff -> eff * weight));
        for (Map.Entry<String, Double> entry : this._estimatedEffectiveByPath.entrySet()) {
            clone.addEstimatedEffective(entry.getKey(), entry.getValue() * weight);
        }
        for (Map.Entry<String, Double> entry : this._computedEffectiveByStep.entrySet()) {
            clone.addComputedEffective(entry.getKey(), entry.getValue() * weight);
        }
        return clone;
    }

    public void setNbOccurrences(Integer nbOccurrences) {
        this._nbOccurrences = nbOccurrences == 0 ? 1 : nbOccurrences;
    }

    public Integer getNbOccurrences() {
        return this._nbOccurrences;
    }

    public void setOverriddenEffective(Optional<Double> overriddenEffective) {
        this._overriddenEffective = overriddenEffective;
    }

    public void setEnteredEffective(Optional<Double> enteredEffective) {
        this._enteredEffective = enteredEffective;
    }

    public void addEstimatedEffective(String itemPath, Double estimatedEffective) {
        this._estimatedEffective = Optional.of(Double.sum(this._estimatedEffective.orElse(0.0), estimatedEffective));
        this._estimatedEffectiveByPath.put(itemPath, estimatedEffective + this._estimatedEffectiveByPath.getOrDefault(itemPath, 0.0));
    }

    public void addComputedEffective(String step, Double computedEffective) {
        this._computedEffective = Optional.of(Double.sum(this._computedEffective.orElse(0.0), computedEffective));
        this._computedEffectiveByStep.put(step, computedEffective + this._computedEffectiveByStep.getOrDefault(step, 0.0));
    }

    public void addLocalEffective(String itemPath, Double localEffective) {
        this._localEffectiveByPath.put(itemPath, localEffective);
    }

    public void add(Effectives effectivesToAdd, String nameInPath) {
        if (this._overriddenEffective.isEmpty() && this._enteredEffective.isEmpty()) {
            Optional<Double> parentLocalEffectives = effectivesToAdd.getOverriddenEffective().or(effectivesToAdd::getEnteredEffective).map(eff -> eff / (double)effectivesToAdd.getNbOccurrences().intValue());
            if (parentLocalEffectives.isPresent()) {
                this.addEstimatedEffective(nameInPath, parentLocalEffectives.get());
            } else {
                for (Map.Entry<String, Double> entry : effectivesToAdd.getEstimatedEffectiveByPath().entrySet()) {
                    this.addEstimatedEffective(entry.getKey() + "/" + nameInPath, entry.getValue());
                }
            }
        }
        for (Map.Entry<String, Double> entry : effectivesToAdd.getComputedEffectiveByStep().entrySet()) {
            this.addComputedEffective(entry.getKey(), entry.getValue());
        }
    }

    public void sum(Effectives effectivesToAdd) {
        for (Map.Entry<String, Double> entry : effectivesToAdd.getEstimatedEffectiveByPath().entrySet()) {
            this.addEstimatedEffective(entry.getKey(), entry.getValue() / (double)effectivesToAdd.getNbOccurrences().intValue());
        }
        for (Map.Entry<String, Double> entry : effectivesToAdd.getComputedEffectiveByStep().entrySet()) {
            this.addComputedEffective(entry.getKey(), entry.getValue() / (double)effectivesToAdd.getNbOccurrences().intValue());
        }
    }

    public Optional<Double> getEnteredEffective() {
        return this._enteredEffective;
    }

    public Optional<Double> getOverriddenEffective() {
        return this._overriddenEffective;
    }

    public Optional<Double> getEstimatedEffective() {
        return this._estimatedEffective;
    }

    public Map<String, Double> getEstimatedEffectiveByPath() {
        return this._estimatedEffectiveByPath;
    }

    public boolean isInconsistentWithParent() {
        return this._isInconsistentWithParent;
    }

    public void setInconsistentWithParent(boolean isInconsistentWithParent) {
        this._isInconsistentWithParent = isInconsistentWithParent;
    }

    public Optional<Double> getComputedEffective() {
        return this._computedEffective;
    }

    public Map<String, Double> getComputedEffectiveByStep() {
        return this._computedEffectiveByStep;
    }

    public Double getLocalEffective(String programItemPath) {
        return this._localEffectiveByPath.get(programItemPath);
    }

    public Map<String, Double> getLocalEffectiveByPath() {
        return this._localEffectiveByPath;
    }
}

