/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.report.impl;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.data.ContentDataHelper;
import org.ametys.cms.repository.Content;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.catalog.CatalogsManager;
import org.ametys.odf.course.Course;
import org.ametys.odf.courselist.CourseList;
import org.ametys.odf.data.EducationalPath;
import org.ametys.odf.program.Container;
import org.ametys.odf.program.Program;
import org.ametys.odf.program.SubProgram;
import org.ametys.odf.program.TraversableProgramPart;
import org.ametys.plugins.odfpilotage.report.PilotageReport;
import org.ametys.plugins.odfpilotage.report.impl.AbstractReport;
import org.ametys.plugins.odfpilotage.report.impl.tree.ProgramItemTree;
import org.ametys.plugins.repository.data.ametysobject.DataAwareAmetysObject;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.plugins.repository.data.holder.group.ModelAwareRepeaterEntry;
import org.ametys.plugins.repository.model.RepositoryDataContext;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewItemAccessor;
import org.ametys.runtime.model.disableconditions.DefaultDisableConditionsEvaluator;
import org.ametys.runtime.model.disableconditions.DisableConditionsEvaluator;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractMCCReport
extends AbstractReport
implements Initializable {
    public static final String PARAMETER_ONE_FILE_BY_PROGRAM = "oneFileByProgram";
    public static final String PARAMETER_FILTER_ON_CURRENT_ORGUNIT = "filterOnCurrentOrgUnit";
    public static final String PARAMETER_FILTER_BY_ORGUNIT = "filterByOrgUnit";
    private static final String __SESSION_NAME_PREFIX = "mccSession";
    protected static final String FIRST_SESSION_NAME = "mccSession1";
    protected static final String SECOND_SESSION_NAME = "mccSession2";
    protected CatalogsManager _catalogsManager;
    protected DisableConditionsEvaluator _disableConditionsEvaluator;
    protected ContentTypeExtensionPoint _contentTypeEP;
    protected View _sessionsView;
    private View _programView;
    private View _subProgramView;
    private View _containerView;
    private View _courseListView;
    private View _courseView;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._contentTypeEP = (ContentTypeExtensionPoint)manager.lookup(ContentTypeExtensionPoint.ROLE);
        this._catalogsManager = (CatalogsManager)manager.lookup(CatalogsManager.ROLE);
        this._disableConditionsEvaluator = (DisableConditionsEvaluator)manager.lookup(DefaultDisableConditionsEvaluator.ROLE);
    }

    public void initialize() throws Exception {
        this._programView = this.getView("org.ametys.plugins.odf.Content.program", "report-mcc");
        this._subProgramView = this.getView("org.ametys.plugins.odf.Content.subProgram", "report-mcc");
        this._containerView = this.getView("org.ametys.plugins.odf.Content.container", "report-mcc");
        this._courseListView = this.getView("org.ametys.plugins.odf.Content.courseList", "report-mcc");
        this._courseView = this.getView("org.ametys.plugins.odf.Content.course", "report-mcc");
        this._sessionsView = this.getView("org.ametys.plugins.odf.Content.course", "report-mcc-sessions");
    }

    @Override
    protected boolean isGeneric() {
        return false;
    }

    @Override
    public String getDefaultOutputFormat() {
        return "pdf";
    }

    @Override
    public Set<String> getSupportedOutputFormats() {
        return Set.of("doc", "xls", "pdf");
    }

    protected View getView(String contentTypeId, String viewName) {
        ContentType contentType = (ContentType)this._contentTypeEP.getExtension(contentTypeId);
        return contentType.getView(viewName);
    }

    @Override
    protected PilotageReport.PilotageReportContent getReportContentForOrgUnit(String outputFormat, Map<String, String> reportParameters) {
        return this._getReportContentForProgramItemsInOrgUnit(outputFormat, reportParameters);
    }

    @Override
    protected Stream<? extends ProgramItem> _getProgramItemsFromProgram(Program program, Map<String, String> reportParameters) {
        if (!Boolean.parseBoolean(reportParameters.get(PARAMETER_ONE_FILE_BY_PROGRAM))) {
            Set years = this._odfHelper.getYears((TraversableProgramPart)program);
            boolean filterOnOrgunit = Boolean.parseBoolean(reportParameters.get(PARAMETER_FILTER_ON_CURRENT_ORGUNIT));
            if (filterOnOrgunit) {
                String currentOrgUnitId = reportParameters.get("orgunit");
                return StringUtils.isNotBlank((CharSequence)currentOrgUnitId) ? years.stream().filter(c -> this._isFromOrgUnit((Content)c, currentOrgUnitId)) : years.stream();
            }
            String selectedOrgUnitId = reportParameters.get(PARAMETER_FILTER_BY_ORGUNIT);
            return StringUtils.isNotBlank((CharSequence)selectedOrgUnitId) ? years.stream().filter(c -> this._isFromOrgUnit((Content)c, selectedOrgUnitId)) : years.stream();
        }
        return super._getProgramItemsFromProgram(program, reportParameters);
    }

    private boolean _isFromOrgUnit(Content programItem, String orgUnitId) {
        return ContentDataHelper.getContentIdsListFromMultipleContentData((ModelAwareDataHolder)programItem, (String)"parentOrgunits").contains(orgUnitId);
    }

    @Override
    public void saxProgramItem(ContentHandler handler, String programItemId, Map<String, String> reportParameters) {
        ProgramItem programItem = (ProgramItem)this._resolver.resolveById(programItemId);
        ProgramItemTree programTree = this.createMCCTreeFromProgramItem(programItem, reportParameters);
        try {
            handler.startDocument();
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("type", this.getType());
            XMLUtils.startElement((ContentHandler)handler, (String)"report", (Attributes)attrs);
            this.saxGlobalInformations(handler, programItem, reportParameters);
            this.saxOtherInformations(handler, programItem, reportParameters);
            this.saxTree(handler, programTree);
            XMLUtils.endElement((ContentHandler)handler, (String)"report");
            handler.endDocument();
        }
        catch (Exception e) {
            this.getLogger().error("An error occured while generating 'MCC' report for program item '{}' ({})", new Object[]{((Content)programItem).getTitle(), programItem.getCode(), e});
        }
    }

    @Override
    public void _saxOrgUnit(ContentHandler handler, String catalog, String lang, String orgUnitId, Map<String, String> reportParameters) {
        throw new UnsupportedOperationException("Impossible to launch the report '" + this.getType() + "' on a orgunit.");
    }

    protected void saxTree(ContentHandler handler, ProgramItemTree tree) throws SAXException {
        ProgramItem programItem = tree.getCurrent();
        if (programItem instanceof Program) {
            Program program = (Program)programItem;
            this.saxContent(handler, "program", (Content)program, this._programView, tree);
        } else if (programItem instanceof SubProgram) {
            SubProgram subProgram = (SubProgram)programItem;
            this.saxContent(handler, "subProgram", (Content)subProgram, this._subProgramView, tree);
        } else if (programItem instanceof Container) {
            Container container = (Container)programItem;
            this.saxContent(handler, "container", (Content)container, this._containerView, tree);
        } else if (programItem instanceof CourseList) {
            CourseList courseList = (CourseList)programItem;
            this.saxContent(handler, "courseList", (Content)courseList, this._courseListView, tree);
        } else if (programItem instanceof Course) {
            Course course = (Course)programItem;
            if (!this.isExcludedFromMCC(tree)) {
                this.saxContent(handler, "course", (Content)course, this._courseView, tree);
            }
        }
    }

    protected abstract boolean isExcludedFromMCC(ProgramItemTree var1);

    protected void saxContent(ContentHandler handler, String tagName, Content content, View view, ProgramItemTree tree) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("id", content.getId());
        attrs.addCDATAAttribute("name", content.getName());
        attrs.addCDATAAttribute("path", tree.getPath().toString());
        if (this._pilotageHelper.canWriteMccRestrictions(content, SECOND_SESSION_NAME)) {
            attrs.addCDATAAttribute("session2", "available");
        }
        XMLUtils.startElement((ContentHandler)handler, (String)tagName, (Attributes)attrs);
        content.dataToSAX(handler, (ViewItemAccessor)view);
        if (content instanceof Course) {
            this.saxMCCs(handler, tree);
        }
        for (ProgramItemTree child : tree.getChildren()) {
            this.saxTree(handler, child);
        }
        XMLUtils.endElement((ContentHandler)handler, (String)tagName);
    }

    protected void saxMCCs(ContentHandler handler, ProgramItemTree tree) throws SAXException {
        XMLUtils.startElement((ContentHandler)handler, (String)"mcc");
        this.saxSession(handler, tree, FIRST_SESSION_NAME);
        this.saxSession(handler, tree, SECOND_SESSION_NAME);
        XMLUtils.endElement((ContentHandler)handler, (String)"mcc");
    }

    protected abstract void saxSession(ContentHandler var1, ProgramItemTree var2, String var3) throws SAXException;

    protected void saxSessionEntryDetails(ContentHandler handler, ModelAwareRepeaterEntry sessionEntry, Content rootContent) throws SAXException {
        String repeaterName = sessionEntry.getHoldingRepeater().getModel().getName();
        sessionEntry.dataToSAX(handler, (ViewItemAccessor)this._sessionsView.getModelViewItem(repeaterName), RepositoryDataContext.newInstance().withObject((DataAwareAmetysObject)rootContent).withDataPath(repeaterName + "[" + sessionEntry.getPosition() + "]"));
    }

    protected ProgramItemTree createMCCTreeFromProgramItem(ProgramItem programItem, Map<String, String> reportParameters) {
        ProgramItemTree programItemTree = new ProgramItemTree(programItem);
        this.populateMCCTree(programItemTree);
        return programItemTree;
    }

    protected abstract void populateMCCTree(ProgramItemTree var1);

    protected void saxGlobalInformations(ContentHandler handler, ProgramItem programItem, Map<String, String> reportParameters) throws SAXException {
        String catalog = programItem.getCatalog();
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("id", catalog);
        XMLUtils.createElement((ContentHandler)handler, (String)"catalog", (Attributes)attrs, (String)this._catalogsManager.getCatalog(catalog).getTitle());
        XMLUtils.createElement((ContentHandler)handler, (String)"title", (String)((Content)programItem).getTitle());
        XMLUtils.createElement((ContentHandler)handler, (String)"lang", (String)programItem.getLanguage());
        for (EducationalPath path : this._odfHelper.getEducationalPaths(programItem, false, true)) {
            String readablePath = path.resolveProgramItems(this._resolver).map(Content.class::cast).map(Content::getTitle).collect(Collectors.joining(" > "));
            XMLUtils.createElement((ContentHandler)handler, (String)"path", (String)readablePath);
        }
    }

    protected void saxOtherInformations(ContentHandler handler, ProgramItem programItem, Map<String, String> reportParameters) throws SAXException {
        this._reportHelper.saxNaturesEnseignement(handler, this.getLogger());
    }
}

