/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.report.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.data.holder.group.ModifiableIndexableRepeater;
import org.ametys.cms.repository.Content;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.course.Course;
import org.ametys.odf.coursepart.CoursePart;
import org.ametys.odf.orgunit.OrgUnit;
import org.ametys.plugins.odfpilotage.cost.CostComputationComponent;
import org.ametys.plugins.odfpilotage.cost.entity.CostComputationData;
import org.ametys.plugins.odfpilotage.cost.entity.EqTD;
import org.ametys.plugins.odfpilotage.cost.entity.ProgramItemData;
import org.ametys.plugins.odfpilotage.helper.ReportHelper;
import org.ametys.plugins.odfpilotage.report.impl.AbstractReport;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.data.holder.group.ModelAwareRepeaterEntry;
import org.ametys.plugins.repository.jcr.SimpleAmetysObject;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class PotentielEnseignantReport
extends AbstractReport {
    protected CostComputationComponent _costComputationComponent;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._costComputationComponent = (CostComputationComponent)((Object)manager.lookup(CostComputationComponent.ROLE));
    }

    @Override
    protected String getType(Map<String, String> reportParameters) {
        return "potentielenseignant";
    }

    @Override
    public String getDefaultOutputFormat() {
        return "xls";
    }

    @Override
    public Set<String> getSupportedOutputFormats() {
        return Set.of("xls");
    }

    @Override
    public void _saxOrgUnit(ContentHandler handler, String catalog, String lang, String orgUnitId, Map<String, String> reportParameters) {
        OrgUnit orgUnit = (OrgUnit)this._resolver.resolveById(orgUnitId);
        Map<String, Double> nbHoursSumByDiscipline = this._sumNbHoursByDiscipline(catalog, lang, orgUnit);
        try {
            handler.startDocument();
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("type", this.getType());
            XMLUtils.startElement((ContentHandler)handler, (String)"report", (Attributes)attrs);
            this._refTableHelper.saxItems(handler, "odf-enumeration.DisciplineEnseignement");
            this._saxPotentielEnseignant(handler, orgUnit);
            this._saxNbHoursSum(handler, nbHoursSumByDiscipline);
            XMLUtils.endElement((ContentHandler)handler, (String)"report");
            handler.endDocument();
        }
        catch (Exception e) {
            this.getLogger().error("An error occured while generating 'Potentiel enseignant' report for orgunit '{}'", (Object)orgUnit.getUAICode(), (Object)e);
        }
    }

    private void _saxNbHoursSum(ContentHandler handler, Map<String, Double> nbHoursSumByDiscipline) throws SAXException {
        XMLUtils.startElement((ContentHandler)handler, (String)"sumsByDiscipline");
        for (String discipline : nbHoursSumByDiscipline.keySet()) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("discipline", discipline);
            XMLUtils.createElement((ContentHandler)handler, (String)"sum", (Attributes)attrs, (String)ReportHelper.FORMAT_2_DIGITS.format(nbHoursSumByDiscipline.get(discipline)));
        }
        XMLUtils.endElement((ContentHandler)handler, (String)"sumsByDiscipline");
    }

    private void _saxPotentielEnseignant(ContentHandler handler, OrgUnit orgUnit) throws SAXException {
        ModifiableIndexableRepeater repeater = orgUnit.getRepeater("potentielsEnseignant");
        XMLUtils.startElement((ContentHandler)handler, (String)"potentiels");
        if (repeater != null) {
            for (ModelAwareRepeaterEntry entry : repeater.getEntries()) {
                XMLUtils.startElement((ContentHandler)handler, (String)"entry");
                this._saxOptional(handler, "discipline", Optional.of("discipline").map(arg_0 -> ((ModelAwareRepeaterEntry)entry).getValue(arg_0)).map(ContentValue::getContentId));
                this._saxOptional(handler, "potentiel", Optional.of("potentiel").map(arg_0 -> ((ModelAwareRepeaterEntry)entry).getValue(arg_0)).map(String::valueOf));
                XMLUtils.endElement((ContentHandler)handler, (String)"entry");
            }
        }
        XMLUtils.endElement((ContentHandler)handler, (String)"potentiels");
    }

    private void _saxOptional(ContentHandler handler, String tagName, Optional<String> value) throws SAXException {
        if (value.isPresent()) {
            XMLUtils.createElement((ContentHandler)handler, (String)tagName, (String)value.get());
        }
    }

    private Map<String, Double> _sumNbHoursByDiscipline(String catalog, String lang, OrgUnit orgUnit) {
        CostComputationData costData = this._costComputationComponent.computeCostsOnOrgUnit(orgUnit, catalog, lang, false);
        LinkedHashSet courseParts = new LinkedHashSet();
        costData.getComputedPrograms().forEach(program -> courseParts.addAll(this._getCoursePartsForProgramItem((ProgramItem)program)));
        HashMap<String, Double> nbHoursSumByDiscipline = new HashMap<String, Double>();
        for (CoursePart coursePart : courseParts) {
            if (!this._isHoldByOrgUnit(coursePart, orgUnit)) continue;
            Double eqTD = Optional.of(coursePart).map(SimpleAmetysObject::getId).map(costData::get).map(ProgramItemData::getEqTD).map(EqTD::getGlobalEqTD).orElse(0.0);
            nbHoursSumByDiscipline.compute(this._getDisciplineEnseignement(coursePart), (k, v) -> v == null ? eqTD : v + eqTD);
        }
        return nbHoursSumByDiscipline;
    }

    private boolean _isHoldByOrgUnit(CoursePart coursePart, OrgUnit orgUnit) {
        Course courseHolder = coursePart.getCourseHolder();
        if (courseHolder == null) {
            this.getLogger().error("Les heures d'enseignement '{}' ({}) n'ont pas d'ELP porteur.", (Object)coursePart.getTitle(), (Object)coursePart.getCode());
            return false;
        }
        Set<OrgUnit> stepOrgUnits = this._retrieveOrgUnits((ProgramItem)courseHolder);
        for (OrgUnit stepOrgUnit : stepOrgUnits) {
            if (this._matchOrgUnit(stepOrgUnit, orgUnit)) continue;
            return false;
        }
        return !stepOrgUnits.isEmpty();
    }

    private Set<OrgUnit> _retrieveOrgUnits(ProgramItem programItem) {
        Set<OrgUnit> directOrgUnits = this._getDirectOrgUnits(programItem);
        return directOrgUnits.isEmpty() ? this._retrieveOrgUnitsFromParents(programItem) : directOrgUnits;
    }

    private Set<OrgUnit> _retrieveOrgUnitsFromParents(ProgramItem programItem) {
        return this._odfHelper.getParentProgramItems(programItem).stream().map(this::_retrieveOrgUnits).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private Set<OrgUnit> _getDirectOrgUnits(ProgramItem programItem) {
        List orgUnitIds = programItem.getOrgUnits();
        return this._resolveAll(orgUnitIds);
    }

    private Set<OrgUnit> _resolveAll(Collection<String> orgUnitIds) {
        return orgUnitIds.stream().map(this::_resolve).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private OrgUnit _resolve(String id) {
        try {
            return (OrgUnit)this._resolver.resolveById(id);
        }
        catch (AmetysRepositoryException e) {
            return null;
        }
    }

    private boolean _matchOrgUnit(OrgUnit orgUnit, OrgUnit orgUnitToMatch) {
        if (orgUnit.equals((Object)orgUnitToMatch)) {
            return true;
        }
        return Optional.of(orgUnit).map(OrgUnit::getParentOrgUnit).map(parent -> this._matchOrgUnit((OrgUnit)parent, orgUnitToMatch)).orElse(false);
    }

    private String _getDisciplineEnseignement(CoursePart coursePart) {
        String disciplineId = this._getDisciplineEnseignementAttribute((Content)coursePart).or(() -> this._getDisciplineEnseignementAttribute((Content)coursePart.getCourseHolder())).orElse("");
        if (StringUtils.isEmpty((CharSequence)disciplineId)) {
            this.getLogger().warn("Les heures d'enseignement '{}' ({}) n'ont pas de discipline associ\u00e9e.", (Object)coursePart.getTitle(), (Object)coursePart.getCode());
        }
        return disciplineId;
    }

    private Optional<String> _getDisciplineEnseignementAttribute(Content content) {
        return Optional.ofNullable(content).map(c -> (ContentValue)c.getValue("disciplineEnseignement")).map(ContentValue::getContentId);
    }

    private List<CoursePart> _getCoursePartsForProgramItem(ProgramItem programItem) {
        Course course;
        if (programItem instanceof Course && (course = (Course)programItem).getCourseLists().isEmpty()) {
            return course.getCourseParts();
        }
        ArrayList<CoursePart> courseParts = new ArrayList<CoursePart>();
        this._odfHelper.getChildProgramItems(programItem).forEach(child -> courseParts.addAll(this._getCoursePartsForProgramItem((ProgramItem)child)));
        return courseParts;
    }
}

