/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.rule.observations;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.data.holder.group.ModifiableIndexableRepeater;
import org.ametys.cms.data.holder.group.ModifiableIndexableRepeaterEntry;
import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Event;
import org.ametys.odf.program.Container;
import org.ametys.plugins.odfpilotage.rule.RulesManager;
import org.ametys.plugins.odfpilotage.rule.ThematicsHelper;
import org.ametys.plugins.odfpilotage.rule.observations.AbstractRulesStepObserver;
import org.ametys.plugins.repository.data.holder.group.RepeaterEntry;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;

public class UpdateContainerRulesStep2Observer
extends AbstractRulesStepObserver {
    protected ThematicsHelper _thematicsHelper;
    protected RulesManager _rulesManager;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._thematicsHelper = (ThematicsHelper)manager.lookup(ThematicsHelper.ROLE);
        this._rulesManager = (RulesManager)((Object)manager.lookup(RulesManager.ROLE));
    }

    @Override
    protected String getSupportedEventId() {
        return "content.modified";
    }

    @Override
    protected boolean supportsContent(Content content) {
        return this._odfHelper.isContainerOfTypeYear(content);
    }

    public void observe(Event event, Map<String, Object> transientVars) throws Exception {
        Container content = (Container)event.getArguments().get("content");
        String regimeId = Optional.ofNullable((ContentValue)content.getValue("mccRegime")).map(ContentValue::getContentId).orElse(null);
        String oldRegimeId = this._getOldRegimeIds((Content)content).stream().findFirst().orElse(null);
        String nbSessions = (String)content.getValue("mccNbSessions");
        String oldNbSessions = this._getOldNumberOfSessions((Content)content);
        if (Strings.CS.equals(regimeId, oldRegimeId) || Strings.CS.equals(StringUtils.defaultString((String)nbSessions), StringUtils.defaultString((String)oldNbSessions))) {
            this._deleteOldRulesOnContainer(content);
        }
    }

    protected void _deleteOldRulesOnContainer(Container content) {
        List<String> compatibleThematicCode = this._thematicsHelper.getCompatibleThematics(content).stream().map(t -> (String)t.getValue("code")).toList();
        Set<Integer> incompatibleRulesPosition = Optional.ofNullable(content).map(c -> (ModifiableIndexableRepeater)c.getValue("rules")).map(ModifiableIndexableRepeater::getEntries).map(Collection::stream).orElseGet(() -> Stream.of(new ModifiableIndexableRepeaterEntry[0])).filter(e -> !this._matchRules((ModifiableIndexableRepeaterEntry)e, compatibleThematicCode)).map(RepeaterEntry::getPosition).collect(Collectors.toSet());
        this._rulesManager.deleteRules(content, incompatibleRulesPosition);
    }

    private boolean _matchRules(ModifiableIndexableRepeaterEntry e, List<String> compatibleThematicCode) {
        if (e.hasValue("thematicCode")) {
            return compatibleThematicCode.contains(e.getValue("thematicCode"));
        }
        String code = (String)e.getValue("code");
        return compatibleThematicCode.stream().map(c -> c + "-").anyMatch(code::startsWith);
    }
}

