/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.rule.observations;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.data.holder.group.ModifiableIndexableRepeaterEntry;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.odf.program.Container;
import org.ametys.plugins.odfpilotage.rule.ThematicsHelper;
import org.ametys.plugins.odfpilotage.rule.observations.AbstractThematicRulesObserver;
import org.ametys.plugins.repository.jcr.DefaultAmetysObject;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;

public class UpdateThematicRulesStep2Observer
extends AbstractThematicRulesObserver {
    protected ThematicsHelper _thematicsHelper;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._thematicsHelper = (ThematicsHelper)manager.lookup(ThematicsHelper.ROLE);
    }

    @Override
    protected String getSupportedEventId() {
        return "content.modified";
    }

    @Override
    protected Map<Container, Set<Integer>> getRulePositionsToDelete(ModifiableContent content, String catalog, String thematicCode, List<? extends ModifiableIndexableRepeaterEntry> ruleEntries) throws RepositoryException {
        Session session = ((DefaultAmetysObject)content).getNode().getSession();
        List<String> ruleCodes = ruleEntries.stream().map(e -> (String)e.getValue("code")).toList();
        if (((Boolean)content.getValue("archived", false, (Object)false)).booleanValue()) {
            List<String> codes = ListUtils.union(ruleCodes, this._getOldModifiedRuleCodes((Content)content)).stream().distinct().toList();
            return this._getContainerRulePositions(session, catalog, thematicCode, codes, true);
        }
        Map<Container, Set<Integer>> rulePositionsByContainer = this._getRulePositionsToDeleteOnRestrictionsChanged(content, session, catalog, thematicCode, ruleCodes);
        List<String> archivedOrModifiedRuleCodes = ruleEntries.stream().filter(c -> this._filterRule((Content)content, (ModifiableIndexableRepeaterEntry)c)).map(e -> (String)e.getValue("code")).toList();
        List<String> oldCodeToDeleted = this._getOldModifiedRuleCodes((Content)content).stream().filter(c -> !ruleCodes.contains(c)).toList();
        this._getContainerRulePositions(session, catalog, thematicCode, ListUtils.union(archivedOrModifiedRuleCodes, oldCodeToDeleted), false).entrySet().stream().forEach(e -> {
            Set positions = rulePositionsByContainer.getOrDefault(e.getKey(), new HashSet());
            positions.addAll((Collection)e.getValue());
            rulePositionsByContainer.put((Container)e.getKey(), positions);
        });
        return rulePositionsByContainer;
    }

    private Map<Container, Set<Integer>> _getRulePositionsToDeleteOnRestrictionsChanged(ModifiableContent content, Session session, String catalog, String thematicCode, List<String> ruleCodes) throws RepositoryException {
        List<String> degreeIds = Stream.of((ContentValue[])content.getValue("degree", false, (Object)new ContentValue[0])).map(ContentValue::getContentId).toList();
        List<String> oldDegreeIds = this._getOldDegreeIds((Content)content);
        List<String> regimeIds = Stream.of((ContentValue[])content.getValue("regime", false, (Object)new ContentValue[0])).map(ContentValue::getContentId).toList();
        List<String> oldRegimeIds = this._getOldRegimeIds((Content)content);
        String nbSessions = (String)content.getValue("nbSessions");
        String oldNbSessions = this._getOldNumberOfSessions((Content)content);
        if (!ListUtils.isEqualList(degreeIds, oldDegreeIds) || !ListUtils.isEqualList(regimeIds, oldRegimeIds) || Strings.CS.equals(StringUtils.defaultString((String)nbSessions), StringUtils.defaultString((String)oldNbSessions))) {
            List<String> nbSessionsAsList = StringUtils.isNotBlank((CharSequence)nbSessions) ? List.of(nbSessions) : List.of();
            List<Container> newCompatibleContainers = this._thematicsHelper.getCompatibleContainers(catalog, nbSessionsAsList, regimeIds, degreeIds, List.of()).toList();
            List<String> oldNbSessionsAsList = StringUtils.isNotBlank((CharSequence)oldNbSessions) ? List.of(oldNbSessions) : List.of();
            List<Container> incompatibleContainers = this._thematicsHelper.getCompatibleContainers(catalog, oldNbSessionsAsList, oldRegimeIds, oldDegreeIds, List.of(Predicate.not(newCompatibleContainers::contains))).toList();
            return this._getContainerRulePositions(session, catalog, thematicCode, ruleCodes, true).entrySet().stream().filter(e -> incompatibleContainers.contains(e.getKey())).collect(Collectors.toMap(e -> (Container)e.getKey(), e -> (Set)e.getValue()));
        }
        return new HashMap<Container, Set<Integer>>();
    }

    private boolean _filterRule(Content content, ModifiableIndexableRepeaterEntry entry) {
        String status;
        boolean isDerogable = (Boolean)entry.getValue("isDerogable", false, (Object)false);
        if (!isDerogable) {
            return true;
        }
        switch (status = (String)entry.getValue("status")) {
            case "SUSPENDED": {
                return true;
            }
            case "MODIFIED": {
                List<String> oldModifiedRuleCodes = this._getOldModifiedRuleCodes(content);
                return !oldModifiedRuleCodes.contains(entry.getValue("code"));
            }
        }
        return false;
    }
}

