/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.tool;

import java.io.File;
import java.io.FileFilter;
import java.time.ZonedDateTime;
import java.util.regex.Pattern;
import org.ametys.core.util.DateUtils;

public class PilotageFileFilter
implements FileFilter {
    private static final Pattern __FILENAME_PATTERN = Pattern.compile("^.*\\.zip$", 2);
    private ZonedDateTime _lastModifiedAfter;
    private ZonedDateTime _lastModifiedBefore;

    public PilotageFileFilter(ZonedDateTime lastModifiedAfter, ZonedDateTime lastModifiedBefore) {
        this._lastModifiedAfter = lastModifiedAfter;
        this._lastModifiedBefore = lastModifiedBefore;
    }

    @Override
    public boolean accept(File pathname) {
        if (pathname.isDirectory()) {
            return false;
        }
        String fileName = pathname.getName().toLowerCase();
        if (!__FILENAME_PATTERN.matcher(fileName).find()) {
            return false;
        }
        if (this._lastModifiedAfter != null || this._lastModifiedBefore != null) {
            ZonedDateTime lastModified = DateUtils.asZonedDateTime((long)pathname.lastModified());
            if (this._lastModifiedAfter != null && lastModified.isBefore(this._lastModifiedAfter)) {
                return false;
            }
            if (this._lastModifiedBefore != null && lastModified.isAfter(this._lastModifiedBefore.plusDays(1L))) {
                return false;
            }
        }
        return true;
    }
}

