/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Helper to select thematics and rules zone. Such a zone can be selected and highlighted.
 * @private
 */
Ext.define('Ametys.plugins.odf.pilotage.ui.UIRules', {
	singleton: true,
	
	/**
	 * Send the thematic element selection
	 * @param {String} containerId The container id
     * @param {String} thematicId The thematic id
     * @param {String} ruleType The thematic type
	 * @param {String} ruleId The rule id. Can be null if no rule selected
	 * @param {String} ruleType The rule type. Can be null if no rule selected
     * @param {Boolean} derogable True if the rule is derogable. Can be null if no rule selected
     * @param {Boolean} derogated True if the rule is derogated. Can be null if no rule selected
     */
    sendSelection: function(containerId, thematicId, thematicType, ruleId, ruleType, derogable, derogated)
    {
        var tool = Ametys.tool.ToolsManager.getTool("uitool-rules$" + containerId);
        if (tool && !tool.hasFocus())
        {
            tool.focus();
        }
        
        var thematicTarget = {
            id: Ametys.message.MessageTarget.THEMATIC,
            parameters: {
                id: thematicId,
                type: thematicType
            }
        };
        
        if (ruleId)
        {
            var ruleTarget = {
                id: Ametys.message.MessageTarget.RULE,
                parameters: {
                    id: ruleId,
                    derogable: derogable,
                    derogated: derogated,
                    type: ruleType
                }
            };
            
            thematicTarget.subtargets = ruleTarget;
        }
        
        var contentTarget = {
            id: Ametys.message.MessageTarget.CONTENT,
            parameters: {
                ids: [containerId]
            }
        }
        contentTarget.subtargets = thematicTarget;

        Ext.create("Ametys.message.Message", {
            type: Ametys.message.Message.SELECTION_CHANGED,
            targets: [contentTarget]
        });
    }
});

