<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:exsl="http://exslt.org/common"
                xmlns:odf="org.ametys.plugins.odfweb.xslt.OdfXSLTHelper"
                exclude-result-prefixes="exsl odf">
     
    <xsl:param name="shortLabelToDisplay">
        <!-- Syntax to force some values to be displayed by short label instead of code
        <display typeId="odf-enumeration.EnseignementNature"/>
         -->
    </xsl:param>
    
    <xsl:variable name="root" select="/"/>
    
    <xsl:variable name="referenceTables">
        <xsl:copy-of select="odf:getTableRefItems('odf-enumeration.CourseNature', /report/lang, true())"/>
    </xsl:variable>
    
    <xsl:variable name="naturesEnseignementByCategory">
        <xsl:for-each select="/report/items[@id = 'odf-enumeration.EnseignementNature']/category">
            <xsl:sort select="@order" data-type="number"/>
            <xsl:sort select="@code" data-type="text"/>
            
            <xsl:variable name="items">
                <xsl:for-each select="item">
                    <xsl:sort select="@order" data-type="number"/>
                    <xsl:sort select="@code" data-type="text"/>
                    
                    <xsl:variable name="currentId" select="@id"/>
                    <xsl:if test="$root//*[@id = $currentId and local-name() != 'item']">
                        <item id="{@id}" code="{@code}"><xsl:value-of select="."/></item>
                    </xsl:if>
                </xsl:for-each>
            </xsl:variable>
            
            <xsl:if test="count(exsl:node-set($items)/item) > 0">
                <category code="{@code}" title="{@title}">
                    <xsl:copy-of select="$items"/>
                </category>
            </xsl:if>
        </xsl:for-each>
    </xsl:variable>
    
    <xsl:variable name="nbNatureEnseignement" select="count(exsl:node-set($naturesEnseignementByCategory)/*)"/>
   
    <xsl:template name="displayCodeOrShortLabel">
        <xsl:param name="contentId"/>
        
        <xsl:variable name="currentEntry" select="$root/report/items//item[@id = $contentId]|exsl:node-set($referenceTables)/items//item[@id = $contentId]"/>
        <xsl:variable name="displayShortLabel" select="$currentEntry/@shortLabel != '' and count(exsl:node-set($shortLabelToDisplay)/display[@typeId = $currentEntry/ancestor::items/@id]) > 0" />
        <xsl:choose>
            <xsl:when test="$displayShortLabel">
                <xsl:value-of select="$currentEntry/@shortLabel"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$currentEntry/@code"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>