/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfpilotage.course;

import java.util.HashMap;
import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.cms.repository.Content;
import org.ametys.odf.contenttype.ODFContentData;
import org.ametys.odf.course.Course;
import org.ametys.plugins.odfpilotage.helper.PilotageHelper;

/**
 * Content data on {@link Course}.
 * FIXME Probably delete this class with ODF fusion plugins in v5. It's created for plugin as Pilotage could add its own data in content properties
 */
public class CourseData implements ODFContentData, Serviceable
{
    /** The pilotage helper */
    protected PilotageHelper _pilotageHelper;
    
    public void service(ServiceManager manager) throws ServiceException
    {
        _pilotageHelper = (PilotageHelper) manager.lookup(PilotageHelper.ROLE);
    }
    
    public Map<String, Object> getAdditionalData(Content content)
    {
        Map<String, Object> data = new HashMap<>();
        
        if (content instanceof Course course)
        {
            data.put("isExcludedFromMCC", _pilotageHelper.isExcludedFromMCC(course));
        }
        
        return data;
    }
    
}
