/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfpilotage.property;

import java.util.Optional;
import java.util.Set;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.tuple.Pair;

import org.ametys.cms.model.properties.AbstractIndexableContentProperty;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.program.ContainerFactory;
import org.ametys.plugins.odfpilotage.helper.PilotageHelper;

/**
 * Property on the computed step holder.
 */
public class ComputedStepHolderProperty extends AbstractIndexableContentProperty<Content>
{
    private PilotageHelper _pilotageHelper;

    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _pilotageHelper = (PilotageHelper) manager.lookup(PilotageHelper.ROLE);
    }
    
    public String getContentTypeId()
    {
        return ContainerFactory.CONTAINER_CONTENT_TYPE;
    }
    
    @Override
    protected Set<? extends ModifiableContent> _getLinkedContents(Content content)
    {
        return Optional.ofNullable(content)
            .filter(ProgramItem.class::isInstance)
            .map(ProgramItem.class::cast)
            .map(_pilotageHelper::getStepHolder)
            .map(Pair::getRight)
            .map(Set::of)
            .orElseGet(Set::of);
    }
}
