/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfpilotage.report.impl;

import java.util.Map;
import java.util.Set;

import org.xml.sax.ContentHandler;

import org.ametys.plugins.odfpilotage.report.AbstractPilotageReport;

/**
 * The abstract class for extractions
 */
public abstract class AbstractExtract extends AbstractPilotageReport
{
    @Override
    protected boolean isSupportedTarget(PilotageReportTarget target)
    {
        return PilotageReportTarget.ORGUNIT.equals(target) || PilotageReportTarget.PROGRAM.equals(target);
    }

    @Override
    public Set<String> getSupportedOutputFormats()
    {
        return Set.of(OUTPUT_FORMAT_DOC);
    }
    
    @Override
    protected PilotageReportContent getReportContentForProgram(String outputFormat, Map<String, String> reportParameters)
    {
        return _getReportContentForProgram(outputFormat, reportParameters);
    }
    
    @Override
    protected PilotageReportContent getReportContentForOrgUnit(String outputFormat, Map<String, String> reportParameters)
    {
        return _getReportContentForProgramItemsInOrgUnit(outputFormat, reportParameters);
    }

    @Override
    public void _saxOrgUnit(ContentHandler handler, String catalog, String lang, String orgUnitId, Map<String, String> reportParameters)
    {
        throw new UnsupportedOperationException("Impossible to launch the report '" + getType() + "' on a orgunit.");
    }
}
