/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfpilotage.workflow;

import java.io.IOException;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;

import org.ametys.odf.program.Container;
import org.ametys.plugins.odfpilotage.helper.ReportHelper;
import org.ametys.plugins.repository.AmetysObjectResolver;

/**
 * Generator to sax MCC workflow for a given container.
 */
public class ContainerMCCWorkflowGenerator extends ServiceableGenerator
{
    /** The ametys object resolver */
    protected AmetysObjectResolver _resolver;
    
    /** The ametys object resolver */
    protected ReportHelper _reportHelper;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _reportHelper = (ReportHelper) smanager.lookup(ReportHelper.ROLE);
        _resolver = (AmetysObjectResolver) smanager.lookup(AmetysObjectResolver.ROLE);
    }
    
    @Override
    public void generate() throws IOException, SAXException, ProcessingException
    {
        Request request = ObjectModelHelper.getRequest(objectModel);
        
        contentHandler.startDocument();
        
        String containerId = request.getParameter("programItem");
        if (StringUtils.isNotBlank(containerId))
        {
            Container container = _resolver.resolveById(containerId);
            _reportHelper.saxMCCWorkflow(contentHandler, container);
        }
        
        contentHandler.endDocument();
    }
}
