/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfsync.cdmfr.transformers;

import java.io.IOException;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class CDMRichTextTransformer
extends AbstractTransformer {
    private static final String __TAG_ARTICLE = "article";
    private static final String __TAG_SECTION = "section";
    private static final String __TAG_TITLE = "title";
    private static final String[] __CHARACTER_TYPES = new String[]{"emphasis", "phrase", "link"};
    private static final String[] __BLOC_TYPES = new String[]{"itemizedlist", "para", "orderedlist", "table"};
    int _sectionCount;
    int _titleCount;
    boolean _inDocbook;
    boolean _inBlock;
    boolean _inSection;
    boolean _inTitle;
    boolean _startPara;

    private void _init() {
        this._sectionCount = 0;
        this._titleCount = 0;
        this._inDocbook = true;
        this._inBlock = false;
        this._inSection = false;
        this._inTitle = false;
        this._startPara = false;
    }

    public void startElement(String uri, String localName, String raw, Attributes attrs) throws SAXException {
        if (__TAG_ARTICLE.equals(localName)) {
            this._init();
        }
        if (this._inDocbook && __TAG_SECTION.equals(localName)) {
            ++this._sectionCount;
            if (this._startPara) {
                this._endParaElement();
            }
        }
        if (this._inDocbook && __TAG_TITLE.equals(localName)) {
            ++this._titleCount;
            this._inTitle = true;
            if (this._titleCount > this._sectionCount) {
                if (this._startPara) {
                    this._endParaElement();
                }
                ++this._sectionCount;
                super.startElement("", __TAG_SECTION, __TAG_SECTION, (Attributes)new AttributesImpl());
            }
        }
        if (ArrayUtils.contains((Object[])__BLOC_TYPES, (Object)localName)) {
            if (this._startPara) {
                this._endParaElement();
            }
            this._inBlock = true;
        }
        if (ArrayUtils.contains((Object[])__CHARACTER_TYPES, (Object)localName) && !this._inBlock) {
            this._startParaElement();
        }
        super.startElement(uri, localName, raw, attrs);
    }

    public void endElement(String uri, String localName, String raw) throws SAXException {
        if (__TAG_ARTICLE.equals(localName)) {
            this._inDocbook = false;
            if (this._startPara) {
                this._endParaElement();
            }
            while (this._sectionCount != 0) {
                this.contentHandler.endElement("", __TAG_SECTION, __TAG_SECTION);
                --this._sectionCount;
                --this._titleCount;
            }
        }
        if (__TAG_TITLE.equals(localName)) {
            this._inTitle = false;
        }
        if (__TAG_SECTION.equals(localName)) {
            --this._sectionCount;
            --this._titleCount;
            if (this._startPara) {
                this._endParaElement();
            }
        }
        if (this._inDocbook && ArrayUtils.contains((Object[])__BLOC_TYPES, (Object)localName)) {
            this._inBlock = false;
        }
        super.endElement(uri, localName, raw);
    }

    public void characters(char[] c, int start, int len) throws SAXException {
        boolean isBlank = StringUtils.isBlank((CharSequence)new String(c, start, len));
        if (!isBlank && this._inDocbook && !this._inBlock && !this._inTitle) {
            this._startParaElement();
        }
        super.characters(c, start, len);
    }

    private void _startParaElement() throws SAXException {
        this._startPara = true;
        this._inBlock = true;
        this.contentHandler.startElement("", "para", "para", new AttributesImpl());
    }

    private void _endParaElement() throws SAXException {
        this._startPara = false;
        this._inBlock = false;
        this.contentHandler.endElement("", "para", "para");
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
    }
}

