/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfsync.pegase.scc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.cms.contenttype.ContentAttributeDefinition;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.repository.ContentQueryHelper;
import org.ametys.cms.repository.ContentTypeExpression;
import org.ametys.odf.courselist.CourseList;
import org.ametys.plugins.odfsync.scc.operator.AbstractODFSynchronizingContentOperator;
import org.ametys.plugins.odfsync.utils.ContentWorkflowDescription;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class PegaseSynchronizingContentOperator
extends AbstractODFSynchronizingContentOperator {
    private AmetysObjectResolver _resolver;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
    }

    @Override
    protected String getHelperRole() {
        return "org.ametys.plugins.odfsync.pegase.scc.operator.PegaseSynchronizingContentOperatorHelper";
    }

    @Override
    public Map<String, List<Object>> transform(ContentType obsoleteCType, Map<String, List<Object>> remoteValues, Logger logger) {
        ContentType contentType = Optional.of(remoteValues).map(v -> (List)v.get("workflowDescription")).map(l -> l.get(0)).map(ContentWorkflowDescription.class::cast).map(ContentWorkflowDescription::getContentType).map(arg_0 -> ((ContentTypeExtensionPoint)this._contentTypeEP).getExtension(arg_0)).orElse(null);
        if (contentType == null) {
            return remoteValues;
        }
        this._transformSpecificValues(contentType.getId(), remoteValues);
        return super.transform(contentType, remoteValues, logger);
    }

    private void _transformSpecificValues(String contentTypeId, Map<String, List<Object>> remoteValues) {
        switch (contentTypeId) {
            case "org.ametys.plugins.odf.Content.program": 
            case "org.ametys.plugins.odf.Content.subProgram": {
                this._transformSpecificAbstractProgramValues(remoteValues);
                break;
            }
        }
        this._transformSpecificCourseListValues(remoteValues);
    }

    private void _transformSpecificAbstractProgramValues(Map<String, List<Object>> remoteValues) {
        List ects = Optional.ofNullable(remoteValues.get("ects")).map(Collection::stream).orElseGet(Stream::empty).filter(Objects::nonNull).map(Object::toString).filter(StringUtils::isNotEmpty).map(Double::valueOf).map(Double::longValue).map(String::valueOf).collect(Collectors.toList());
        if (ects.isEmpty()) {
            remoteValues.remove("ects");
        } else {
            remoteValues.put("ects", ects);
        }
    }

    private void _transformSpecificCourseListValues(Map<String, List<Object>> remoteValues) {
        String choiceType = Optional.ofNullable(this._getFirstValueAsString(remoteValues.remove("plageDeChoix"))).map(Boolean::parseBoolean).orElse(false) != false ? CourseList.ChoiceType.CHOICE.toString() : (Optional.ofNullable(this._getFirstValueAsString(remoteValues.remove("obligatoire"))).map(Boolean::parseBoolean).orElse(false) != false ? CourseList.ChoiceType.MANDATORY.toString() : CourseList.ChoiceType.OPTIONAL.toString());
        remoteValues.put("choiceType", List.of(choiceType));
    }

    @Override
    protected List<Object> _transformContentAttributeValues(ContentAttributeDefinition definition, List<Object> values, Logger logger) {
        if (definition.getName().equals("orgUnit")) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object value : values) {
                if (value == null) continue;
                ContentTypeExpression cTypeExpr = new ContentTypeExpression(Expression.Operator.EQ, new String[]{"org.ametys.plugins.odf.Content.orgunit"});
                StringExpression valueExpr = new StringExpression("pegaseCode", Expression.Operator.EQ, (String)value);
                String xpathQuery = ContentQueryHelper.getContentXPathQuery((Expression)new AndExpression(new Expression[]{cTypeExpr, valueExpr}));
                String orgUnitId = this._resolver.query(xpathQuery).stream().findFirst().map(AmetysObject::getId).orElse(null);
                if (orgUnitId == null) continue;
                result.add(orgUnitId);
            }
            return result;
        }
        return super._transformContentAttributeValues(definition, values, logger);
    }
}

