<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdm="http://cdm-fr.fr/2013/CDM"
    xmlns:cdmfr="http://cdm-fr.fr/2013/CDM-frSchema"
    xmlns:ametys-cdm="http://www.ametys.org/cdm/1.0"
    exclude-result-prefixes="cdm cdmfr ametys-cdm">
    
    <!-- Course parts -->
    <xsl:template name="course-courseParts">
        <xsl:for-each select="cdm:infoBlock[@userDefined = 'ametys-extension']/cdm:extension/ametys-cdm:coursePart">
            <coursePart>
                <code><xsl:value-of select="@code"/></code>
                <title><xsl:value-of select="ametys-cdm:title"/></title>
                <nature><xsl:value-of select="ametys-cdm:nature"/></nature>
                <nbHours><xsl:value-of select="ametys-cdm:nbHours"/></nbHours>
                <courseHolder><xsl:value-of select="ametys-cdm:courseHolder"/></courseHolder>
            </coursePart>
        </xsl:for-each>
    </xsl:template>
    
    <!-- FIXME ODF-3951 not imported -->
    <!-- Acquired skills -->
    <xsl:template name="course-acquiredMicroSkills">
<!--         <xsl:if test="cdm:infoBlock[@userDefined = 'ametys-extension']//cdm:extension/ametys-cdm:acquiredMicroSkills"> -->
<!--             <acquiredMicroSkills> -->
<!--                 <xsl:for-each select="cdm:infoBlock[@userDefined = 'ametys-extension']//cdm:extension/ametys-cdm:acquiredMicroSkills/ametys-cdm:acquiredMicroSkillByProgram"> -->
<!--                     <entry name="{position()}"> -->
<!--                         <xsl:if test="ametys-cdm:program"> -->
<!--                             <program><xsl:value-of select="ametys-cdm:program/@code"/></program> -->
<!--                         </xsl:if> -->
<!--                         <xsl:if test="ametys-cdm:skill"> -->
<!--                             <microSkills> -->
<!--                             <xsl:for-each select="ametys-cdm:skill"> -->
<!--                                 <xsl:if test="ametys-cdm:skill"> -->
<!--                                     <item><xsl:value-of select="ametys-cdm:skill/@code"/></item> -->
<!--                                 </xsl:if> -->
<!--                             </xsl:for-each> -->
<!--                             </microSkills> -->
<!--                         </xsl:if> -->
<!--                     </entry> -->
<!--                 </xsl:for-each> -->
<!--             </acquiredMicroSkills> -->
<!--         </xsl:if> -->
    </xsl:template>
    
</xsl:stylesheet>
