/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfsync.apogee.scc;

import java.util.List;
import java.util.Map;

import org.apache.cocoon.environment.Request;

import org.ametys.cms.repository.ModifiableContent;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.orgunit.OrgUnit;
import org.ametys.odf.workflow.AbstractCreateODFContentFunction;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.Expression.Operator;
import org.ametys.plugins.repository.query.expression.StringExpression;

/**
 * Abstract class for Apogee synchronization, contents with catalog (not {@link OrgUnit}).
 */
public abstract class AbstractApogeeSynchronizableContentsWithCatalogCollection extends AbstractApogeeSynchronizableContentsCollection
{
    @Override
    protected Map<String, Object> _getAdditionalInputsForContentCreation()
    {
        Map<String, Object> inputs = super._getAdditionalInputsForContentCreation();
        
        String catalog = _apogeeSCCHelper.getSynchronizationCatalog();
        if (catalog != null)
        {
            inputs.put(AbstractCreateODFContentFunction.CONTENT_CATALOG_KEY, catalog);
        }
        
        return inputs;
    }
    
    @Override
    protected List<Expression> _getExpressionsList(String lang, String idValue, String contentType, boolean forceStrictCheck)
    {
        List<Expression> expList = super._getExpressionsList(lang, idValue, contentType, forceStrictCheck);

        String catalog = _apogeeSCCHelper.getSynchronizationCatalog();
        if (catalog != null)
        {
            expList.add(new StringExpression(ProgramItem.CATALOG, Operator.EQ, catalog));
        }
        
        return expList;
    }
    
    @Override
    protected void _addContentAttributes(Request request, ModifiableContent content)
    {
        super._addContentAttributes(request, content);
        if (content.hasValue(ProgramItem.CATALOG))
        {
            request.setAttribute(ApogeeSynchronizableContentsCollectionHelper.CATALOG, content.getValue(ProgramItem.CATALOG));
        }
    }
    
    @Override
    protected void _removeContentAttributes(Request request)
    {
        super._removeContentAttributes(request);
        request.removeAttribute(ApogeeSynchronizableContentsCollectionHelper.CATALOG);
    }
}
