/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfsync.apogee.scc.operator;

import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

import org.ametys.cms.contenttype.ContentType;
import org.ametys.odf.courselist.CourseList;
import org.ametys.odf.courselist.CourseList.ChoiceType;

/**
 * Get mapped values from Apogée to Ametys for CourseList.
 */
public class ApogeeSynchronizingCourseListOperator extends ApogeeSynchronizingContentOperator
{
    @Override
    public Map<String, List<Object>> transform(ContentType cType, Map<String, List<Object>> remoteValues, Logger logger)
    {
        Map<String, List<Object>> result = super.transform(cType, remoteValues, logger);

        String min = _getFirstValueAsString(remoteValues.get(CourseList.MIN_COURSES));
        String choiceType = _getFirstValueAsString(remoteValues.get(CourseList.CHOICE_TYPE));
        
        if (choiceType.equalsIgnoreCase("O"))
        {
            choiceType = ChoiceType.MANDATORY.toString();
            result.put(CourseList.MIN_COURSES, List.of(Long.valueOf(0)));
            result.put(CourseList.MAX_COURSES, List.of(Long.valueOf(0)));
        }
        else if (StringUtils.isNotEmpty(min))
        {
            choiceType = ChoiceType.CHOICE.toString();
            result.put(CourseList.MIN_COURSES, List.of(Long.valueOf(min)));
            String max = _getFirstValueAsString(remoteValues.get(CourseList.MAX_COURSES));
            if (StringUtils.isNotEmpty(max))
            {
                result.put(CourseList.MAX_COURSES, List.of(Long.valueOf(max)));
            }
            else
            {
                result.put(CourseList.MAX_COURSES, List.of());
            }
        }
        else
        {
            choiceType = ChoiceType.OPTIONAL.toString();
            result.put(CourseList.MIN_COURSES, List.of());
            result.put(CourseList.MAX_COURSES, List.of());
        }

        result.put(CourseList.CHOICE_TYPE, List.of(choiceType));

        return result;
    }
}
