/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfsync.cdmfr;

import org.slf4j.Logger;
import org.w3c.dom.Document;

import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollection;

/**
 * Context of imported content for CDM-fr
 */
public final class ImportCDMFrContext
{
    /** The Synchronizable content collection */
    private SynchronizableContentsCollection _scc;
    
    /** The document that is being imported */
    private Document _document;
    
    /** The language of the imported contents */
    private String _lang;
    
    /** The catalog which will contain the imported contents */
    private String _catalog;
    
    /** The logger */
    private Logger _logger;
    
    /**
     * Creates a CDM-fr context from the given one
     * @param context the context to copy
     */
    public ImportCDMFrContext(ImportCDMFrContext context)
    {
        this(context.getSCC(), context.getDocument(), context.getLang(), context.getCatalog(), context.getLogger());
    }

    /**
     * Creates a CDM-fr context
     * @param scc The synchronizable content collection
     * @param document the document that is being imported
     * @param lang the language of the imported content
     * @param catalog the catalog which will contain the imported content
     * @param logger the logger
     */
    public ImportCDMFrContext(SynchronizableContentsCollection scc, Document document, String lang, String catalog, Logger logger)
    {
        _scc = scc;
        _document = document;
        _lang = lang;
        _catalog = catalog;
        _logger = logger;
    }
    
    /**
     * Retrieves the synchronizable content collection
     * @return the synchronizable content collection
     */
    public SynchronizableContentsCollection getSCC()
    {
        return _scc;
    }

    /**
     * Retrieves the document that is being imported
     * @return the document that is being imported
     */
    public Document getDocument()
    {
        return _document;
    }
    
    /**
     * Set the language of the content to import
     * @param lang the language of the content to import
     */
    public void setLang(String lang)
    {
        _lang = lang;
    }

    /**
     * Retrieves the language of the imported content
     * @return the language of the imported content
     */
    public String getLang()
    {
        return _lang;
    }

    /**
     * Retrieves the catalog which will contain the imported content
     * @return the catalog which will contain the imported content
     */
    public String getCatalog()
    {
        return _catalog;
    }
    
    /**
     * Retrieves the logger
     * @return the logger
     */
    public Logger getLogger()
    {
        return _logger;
    }
}
