/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.ametys.plugins.odfsync.pegase.scc;

import java.util.Map;

import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

import org.ametys.plugins.odfsync.generic.scc.AbstractMappingHelper;

/**
 * Helper for the Pégase SCC (COF).
 */
public class PegaseSCCMappingHelper extends AbstractMappingHelper implements Component
{
    /** Role */
    public static final String ROLE = PegaseSCCMappingHelper.class.getName();
    /** The base uri */
    protected String _baseUri;
    /** Mappings Pégase codes - Ametys code */
    protected Map<String, String> _ametysTypeForPegaseOFType;
    
    @Override
    public void configure(Configuration configuration) throws ConfigurationException
    {
        super.configure(configuration);
        
        _baseUri = configuration.getChild("baseUri").getValue();
    }
    
    /**
     * Get the Ametys type from the Pégase type
     * @param pegaseType The Pégase type
     * @return The Ametys type
     */
    public String getAmetysType(String pegaseType)
    {
        if (_ametysTypeForPegaseOFType == null)
        {
            _ametysTypeForPegaseOFType = _readMapping(_baseUri);
        }
        
        return _ametysTypeForPegaseOFType.get(pegaseType);
    }
}
